package com.bxm.localnews.common.util;

import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.common.vo.RdPage;

/**
 * 响应结果转换工具类
 * 用于和原本黄瓜头条中的API进行适配
 * @author liujia
 */
public class ResultUtil {

    public static <T> Json<T> genSuccessResult() {
        return Json.build(RespCode.OK, "");
    }

    public static <T> Json<T> genSuccessMsg() {
        return Json.build(RespCode.OK, "操作成功");
    }

    public static <T> Json<T> genSuccessMsg(String msg) {
        return Json.build(RespCode.OK, msg);
    }

    public static <T> Json<T> genSuccessResult(T data) {
        return Json.build(RespCode.OK, "", data);
    }

    /**
     * 返回结果，包含分页参数
     * @param data 返回数据
     * @param page 分页对象
     * @return 标准返回对象
     * @deprecated 不推荐使用，推荐使用{@link com.bxm.newidea.component.vo.PageWarper}
     */
    @Deprecated
    public static <T> Json<T> genSuccessResultWithPage(T data, MPage page) {
        return Json.build(RespCode.OK, "", data, page);
    }

    public static <T> Json<T> genSuccessResultWithPage(T data, RdPage page) {
        return Json.build(RespCode.OK, "", data, page);
    }

    public static <T> Json<T> genFailedResult(String msg) {
        return Json.build(RespCode.BAD_REQUEST, msg);
    }

    public static <T> Json<T> genFailedResult(int code, String msg) {
        return Json.build(code, msg);
    }

    public static <T> Json<T> genFailedResult(int code, String msg, T data) {
        return Json.build(code, msg, data);
    }

}
