/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.common.handler;

import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.exception.BusinessException;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.util.WebUtils;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
@ResponseBody
public class CustomizeExceptionHandler {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value={BusinessException.class})
    public Json handlBusinessException(BusinessException e, HttpServletRequest request) {
        this.loginError(request);
        this.logger.error(e.getMessage(), (Throwable)e);
        return Json.build(RespCode.BAD_REQUEST, e.getMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public Json handlBusinessException(IllegalArgumentException e, HttpServletRequest request) {
        this.loginError(request);
        this.logger.error(e.getMessage(), (Throwable)e);
        return Json.build(RespCode.BAD_REQUEST, e.getMessage());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Json handlBusinessException(HttpRequestMethodNotSupportedException e, HttpServletRequest request) {
        this.loginError(request);
        this.logger.error(e.getMessage(), (Throwable)e);
        return Json.build(RespCode.METHOD_NOT_ALLOWED, e.getMessage());
    }

    protected void loginError(HttpServletRequest request) {
        this.logger.error("request uri:[{}],request param:[{}]", (Object)request.getRequestURI(), (Object)WebUtils.getReqeustParam((HttpServletRequest)request));
    }

    @ExceptionHandler(value={Exception.class})
    public Json handlException(Exception e, HttpServletRequest request) {
        this.loginError(request);
        this.logger.error(e.getMessage(), (Throwable)e);
        return Json.build(RespCode.INTERNAL_SERVER_ERROR, "\u670d\u52a1\u5668\u9519\u8bef");
    }
}

