package com.bxm.localnews.mq.common.constant;

import com.bxm.newidea.component.tools.NumberUtils;

import static com.bxm.localnews.mq.common.constant.MessageBehaviorEnum.JUMP;
import static com.bxm.localnews.mq.common.constant.MessageBehaviorEnum.UN_JUMP;


/**
 * 推送消息
 */
public enum PushMessageEnum {

    SYSTEM_MSG(0, "系统公告", UN_JUMP, Boolean.FALSE),
    ORDINARY_MSG(1, "提示消息", UN_JUMP, Boolean.FALSE),
    INTERACTION_MSG(5, "互动消息", UN_JUMP, Boolean.FALSE),
    POST(8, "帖子", JUMP, Boolean.FALSE),
    NEWS(9, "新闻", JUMP, Boolean.FALSE),
    OPEN_URL(10, "打开链接", JUMP, Boolean.FALSE),
    PARTICIPATE_PRIVILEGE_SUCCESS(11, "参加活动成功", JUMP, Boolean.FALSE),
    PRIVILEGE_OPEN_PRIZE(12, "活动开奖", JUMP, Boolean.FALSE),
    PRIVILEGE_WINNING(13, "活动中奖", JUMP, Boolean.FALSE),
    TASK_COMPLETED(15, "任务完成（日常/新手）", UN_JUMP, Boolean.TRUE),
    NEW_MERCHANT(16, "商家提交信息成功", UN_JUMP, Boolean.FALSE),
    MERCHANT_VERIFY(18, "商家审核失败", UN_JUMP, Boolean.FALSE),

    VIP_FRIEND_HELP(30, "用户激活vip时好友助力", JUMP, Boolean.FALSE),
    VIP_ACTIVATION_SUCCESS(31, "用户激活vip", JUMP, Boolean.FALSE),
    VIP_NOT_ACTIVATION(32, "未激活VIP", JUMP, Boolean.FALSE),
    VIP_CONTINUE_ACTIVATION(33, "继续激活VIP", JUMP, Boolean.FALSE),
    VIP_ACTIVATION(34, "已激活VIP", JUMP, Boolean.FALSE),

    NEWS_REPLY(50, "新闻回复", JUMP, Boolean.FALSE),
    NEWS_LIKE(51, "新闻点赞", JUMP, Boolean.FALSE),
    POST_REPLY(52, "帖子回复", JUMP, Boolean.FALSE),
    POST_LIKE(53, "帖子点赞", JUMP, Boolean.FALSE),
    POST_REVIEW_PASS(54, "帖子审核通过", JUMP, Boolean.FALSE),
    ESSENCE_POST(55, "精华帖通知", JUMP, Boolean.FALSE),
    CASH_POST(56, "现金帖", JUMP, Boolean.FALSE),
    BELONG_POST_REPLY(57, "帖子所属人回复", JUMP, Boolean.FALSE),
    BELONG_POST_LIKE(58, "帖子所属人点赞", JUMP, Boolean.FALSE),
    UPDATE_GOLD(59, "金币变动(不发送推送)", JUMP, Boolean.FALSE),

    FAIL_WITHDRAW(60, "您的微信号未实名认证，提现失败", JUMP, Boolean.FALSE),
    ADD_CASH(61, "新增赏金", JUMP, Boolean.FALSE),
    SUCCESS_WITHDRAW(62, "您的提现已成功打款", JUMP, Boolean.FALSE),

    RED_PACKET_PASS(70, "创建的红包审核通过", JUMP, Boolean.FALSE),
    RED_PACKET_NOT_PASS(71, "创建的红包审核不通过", JUMP, Boolean.FALSE),
    RECEIVE_RED_PACKET(72, "红包已被人领取", JUMP, Boolean.FALSE),
    REA_PACKET_FINISH(73, "红包领取完毕", JUMP, Boolean.FALSE),

    FORWARDING(80, "转发通知", JUMP, Boolean.FALSE),
    INVITE(81, "邀请通知", JUMP, Boolean.FALSE),
    POST_ADD_RECOMMAND(82, "帖子加入推荐库通知用户", JUMP, Boolean.FALSE),
    BROKE_POST(83, "爆料帖", JUMP, Boolean.FALSE),

    /**
     * @deprecated {@link UserEventEnum}
     */
    @Deprecated
    USER_ACCOUNT_ENVET(90, "用户金额变动", JUMP, Boolean.FALSE),

    /**
     * @deprecated {@link UserEventEnum}
     */
    @Deprecated
    USER_UN_READ_MSG(91, "用户未读消息数量", JUMP, Boolean.FALSE),

    /**
     * @deprecated {@link UserEventEnum}
     */
    @Deprecated
    APPLET_USER_UN_READ_MSG(92, "用户未读消息数量", JUMP, Boolean.FALSE),

    /**
     * @deprecated {@link UserEventEnum}
     */
    @Deprecated
    TASK_COMPLETE_EVENT(93, "任务完成提示", JUMP, Boolean.FALSE),

    /**
     * @deprecated {@link UserEventEnum}
     */
    @Deprecated
    IM_UNBLOCK(94, "解除用户封禁", JUMP, Boolean.TRUE),

    ADD_FUNS(98, "新增粉丝", JUMP, Boolean.TRUE),
    IM_MESSAGE(99, "即时通讯消息", JUMP, Boolean.TRUE);

    private int type;

    private String desc;

    //是否需要跳转
    private MessageBehaviorEnum behavior;

    //是否静默推送（无通知栏）
    private Boolean silence;

    PushMessageEnum(int type, String desc, MessageBehaviorEnum behavior, Boolean silence) {
        this.type = type;
        this.desc = desc;
        this.behavior = behavior;
        this.silence = silence;
    }

    public static String getMessageDescByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() == type) {
                return messageEnum.getDesc();
            }
        }
        return null;
    }

    public static String getMessageDescByType(String type) {
        return getMessageDescByType(NumberUtils.parseToInt(type));
    }

    public static MessageBehaviorEnum getMessageBehaviorByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() == type) {
                return messageEnum.getBehavior();
            }
        }
        return null;
    }

    public static Boolean getMessageSilenceByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() == type) {
                return messageEnum.getSilence();
            }
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public MessageBehaviorEnum getBehavior() {
        return behavior;
    }

    public void setBehavior(MessageBehaviorEnum behavior) {
        this.behavior = behavior;
    }

    public Boolean getSilence() {
        return silence;
    }

    public void setSilence(Boolean silence) {
        this.silence = silence;
    }
}
