package com.bxm.localnews.mq.common.model.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 
 */
@Data
public class UserRecommendDTO implements Serializable {
    /**
     * 用户id
     */
    private Long userId;

    /**
     * 出生日期
     */
    private Date birth;

    /**
     * 性别
     */
    private Byte sex;

    /**
     * 家乡地区编码
     */
    private String hometownCode;

    /**
     * 当前地区编码
     */
    private String locationCode;

    /**
     * 最后登录时间
     */
    private Date lastLoginTime;

    /**
     * 最后发帖时间
     */
    private Date lastPostTime;

    /**
     * 资料完整度
     */
    private Integer infoCompletePercent;

    /**
     * 权重
     */
    private Integer weight;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;

    /**
     * 当前地理位置坐标
     */
    private byte[] userPosition;

    private static final long serialVersionUID = 1L;

}