package com.bxm.localnews.common.util;

import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;

import java.util.Calendar;
import java.util.Date;

import static com.bxm.newidea.component.tools.DateUtils.addField;
import static org.apache.commons.lang3.time.DateUtils.isSameDay;

/**
 * 内部日期格式化工具
 * @author liujia
 */
public class DateFormatUtils {

    /**
     * 根据产品需求，对日期进行可视化（友好）的处理
     * @param time 待格式化日期
     * @return 格式化结果
     */
    public static String format(Date time) {
        Date today = new Date();
        String changeTime = DateUtils.formatDate(time);

        if (isSameDay(time, today)) {
            return "今天" + DateUtils.PATTERN_HOUR_MINUTE_FORMAT.get().format(time);
        }

        if (isSameDay(addField(time, Calendar.DATE, 1), today)) {
            return "昨天";
        }

        int todayYear = DateUtils.getField(today, Calendar.YEAR);
        int dateYear = DateUtils.getField(time, Calendar.YEAR);

        //跨年显示年月日
        if (todayYear != dateYear) {
            return changeTime.replaceAll("-", "/");
        }

        //同一年显示月和日
        String[] dateArray = StringUtils.split(changeTime, "-");
        return dateArray[1] + "/" + dateArray[2];
    }
}
