/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.common.constant;

import java.util.Optional;
import java.util.stream.Stream;

public enum AliMqMsgTagEnum {
    SMS("sms", "sms", "smsProducer"),
    PUSH("push", "push", "pushProducer"),
    SHARE("news", "share", "newsProducer"),
    VIEW("news", "view", "newsProducer"),
    RECOMMENDED("news", "recommended", "newsProducer"),
    NEW_CLICK("news", "newClick", "newsProducer"),
    COLLECT("news", "collect", "newsProducer"),
    COMMENT("news", "comment", "newsProducer"),
    VIDEO_BLACK("news", "video_black", "newsProducer"),
    VIDEO_SHARE("news", "video_share", "newsProducer"),
    VIDEO_VIEW("news", "video_view", "newsProducer"),
    VIDEO_COMMENT("news", "video_comment", "newsProducer"),
    USER_RECOMMEND_ATTRIBUTE("user_recommend", "attribute", "userRecommendProducer"),
    USER_RECOMMEND_BEHAVIOR("user_recommend", "behavior", "userRecommendProducer"),
    USER_RECOMMEND_POSITION("user_recommend", "position", "userRecommendProducer");

    private String topicType;
    private String tag;
    private String producerName;

    private AliMqMsgTagEnum(String topicType, String tag, String producerName) {
        this.topicType = topicType;
        this.tag = tag;
        this.producerName = producerName;
    }

    public static Optional<AliMqMsgTagEnum> getTagEnumByTag(String tag) {
        return Stream.of(AliMqMsgTagEnum.values()).filter(tagEnum -> tag.equals(tagEnum.getTag())).findAny();
    }

    public static String getTopicTypeByTag(String tag) {
        Optional<AliMqMsgTagEnum> tagEnumOptional = AliMqMsgTagEnum.getTagEnumByTag(tag);
        if (tagEnumOptional.isPresent()) {
            return tagEnumOptional.get().getTopicType();
        }
        return "";
    }

    public static String getProducerNameByTag(String tag) {
        Optional<AliMqMsgTagEnum> tagEnumOptional = AliMqMsgTagEnum.getTagEnumByTag(tag);
        if (tagEnumOptional.isPresent()) {
            return tagEnumOptional.get().getProducerName();
        }
        return "producer";
    }

    public String getProducerName() {
        return this.producerName;
    }

    public String getTopicType() {
        return this.topicType;
    }

    public String getTag() {
        return this.tag;
    }
}

