package com.bxm.localnews.auth.enums;

/**
 * 鉴权码枚举
 * @author liujia
 */
public enum AuthCodeEnum {

    /**
     * 聊天室-是否可以抢红包
     */
    PICK_RED_PACKAGE(0),

    /**
     * 聊天室-禁止在群聊中发言
     */
    BANNED_TO_POST(1),

    /**
     * 聊天室-阶段禁言（禁言一小时、一天）
     */
    BANNED_PHASE(2),

    /**
     * 聊天室-解除用户禁言
     */
    UNBANNED_TO_POST(3),

    /**
     * 聊天室-撤回用户发言
     */
    RECALL_MESSAGE(4);

    /**
     * 权限位在权限编码中的bit位置
     * 从0开始，每64位新增一个group
     */
    public int index;

    AuthCodeEnum(int index) {
        this.index = index;
    }

    /**
     * 根据权限索引获取对应的编码枚举
     * @param index 权限索引
     * @return 权限枚举
     */
    public static AuthCodeEnum getByIndex(Integer index) {
        for (AuthCodeEnum authCodeEnum : AuthCodeEnum.values()) {
            if (index == authCodeEnum.index) {
                return authCodeEnum;
            }
        }
        return null;
    }
}
