package com.bxm.localnews.common.constant;

/**
 * redis发布-订阅模型，订阅频道枚举类
 */
public enum RedisMessageChannel {

    USER_UPDATE_EVENT((byte)100000,"user_update_event", "用户信息更新事件");

    /**
     * 编码，我喜欢6位，别问为什么
     */
    private byte code;

    /**
     * 订阅的频道的名称
     */
    private String name;

    /**
     * 订阅的频道的描述
     */
    private String desc;

    RedisMessageChannel(byte code,String name, String desc) {
        this.code = code;
        this.name = name;
        this.desc = desc;
    }

    public byte getCode() {
        return code;
    }

    public void setCode(byte code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
