package com.bxm.localnews.common.param;

import com.bxm.localnews.common.vo.BasicParam;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 数据埋点相关参数
 * 详细定义见：
 * http://10.10.1.40:8090/pages/viewpage.action?pageId=950517
 */
public class PointReportParam {
    /**
     * 客户端设备ID
     */
    private String did;

    /**
     * 客户端版本号
     */
    private String v;

    /**
     * 事件编码，取值见CF
     */
    private String e;

    /**
     * 事件值
     */
    private String ev;

    /**
     * 上报的数据来源，固定值
     */
    private String p;

    /**
     * 请求的设备客户端类型
     */
    private String dtype;

    /**
     * 事件额外参数，key参见埋点事件文档定义，value为对应的值
     */
    private Map<String, String> extendMap;

    private PointReportParam() {
    }

    public static PointReportParam build() {
        PointReportParam param = new PointReportParam();
        param.p = "news";
        param.extendMap = Maps.newHashMap();
        param.put("ts", String.valueOf(System.currentTimeMillis()));
        return param;
    }

    public static PointReportParam build(BasicParam basicParam) {
        PointReportParam param = build();
        param.dtype = String.valueOf(basicParam.getPlatform());
        param.did = basicParam.getDevcId();
        param.v = basicParam.getCurVer();
        param.put("ts", String.valueOf(basicParam.getCliTime()));
        return param;
    }

    public PointReportParam put(String key, String value) {
        extendMap.put(key, value);
        return this;
    }

    public Map<String, String> getMap() {
        extendMap.put("did", this.did);
        extendMap.put("e", this.e);
        extendMap.put("ev", this.ev);
        extendMap.put("v", this.v);
        extendMap.put("dtype", this.dtype);
        return extendMap;
    }

    public PointReportParam did(String did) {
        this.did = did;
        return this;
    }

    public PointReportParam dtype(String dtype) {
        this.dtype = dtype;
        return this;
    }

    public PointReportParam v(String v) {
        this.v = v;
        return this;
    }

    public PointReportParam e(String e) {
        this.e = e;
        return this;
    }

    public PointReportParam ev(String ev) {
        this.ev = ev;
        return this;
    }
}
