/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.common.constant;

import java.util.Optional;
import java.util.stream.Stream;

public enum AliMqMsgTagEnum {
    SMS("sms", "sms", "smsProducer"),
    PUSH("push", "push", "pushProducer");

    private String topicType;
    private String tag;
    private String producerName;

    private AliMqMsgTagEnum(String topicType, String tag, String producerName) {
        this.topicType = topicType;
        this.tag = tag;
        this.producerName = producerName;
    }

    public static Optional<AliMqMsgTagEnum> getTagEnumByTag(String tag) {
        return Stream.of(AliMqMsgTagEnum.values()).filter(tagEnum -> tag.equals(tagEnum.getTag())).findAny();
    }

    public static String getTopicTypeByTag(String tag) {
        Optional<AliMqMsgTagEnum> tagEnumOptional = AliMqMsgTagEnum.getTagEnumByTag(tag);
        if (tagEnumOptional.isPresent()) {
            return tagEnumOptional.get().getTopicType();
        }
        return "";
    }

    public static String getProducerNameByTag(String tag) {
        Optional<AliMqMsgTagEnum> tagEnumOptional = AliMqMsgTagEnum.getTagEnumByTag(tag);
        if (tagEnumOptional.isPresent()) {
            return tagEnumOptional.get().getProducerName();
        }
        return "producer";
    }

    public String getProducerName() {
        return this.producerName;
    }

    public String getTopicType() {
        return this.topicType;
    }

    public String getTag() {
        return this.tag;
    }
}

