/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.common.constant;

import com.bxm.localnews.mq.common.constant.MessageBehaviorEnum;
import com.bxm.newidea.component.tools.NumberUtils;

public enum PushMessageEnum {
    SYSTEM_MSG(0, "\u7cfb\u7edf\u516c\u544a", MessageBehaviorEnum.UN_JUMP, Boolean.FALSE),
    ORDINARY_MSG(1, "\u63d0\u793a\u6d88\u606f", MessageBehaviorEnum.UN_JUMP, Boolean.FALSE),
    NEWS(9, "\u65b0\u95fb", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    OPEN_URL(10, "\u6253\u5f00\u94fe\u63a5", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    PARTICIPATE_PRIVILEGE_SUCCESS(11, "\u53c2\u52a0\u6d3b\u52a8\u6210\u529f", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    PRIVILEGE_OPEN_PRIZE(12, "\u6d3b\u52a8\u5f00\u5956", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    PRIVILEGE_WINNING(13, "\u6d3b\u52a8\u4e2d\u5956", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    TASK_COMPLETED(15, "\u4efb\u52a1\u5b8c\u6210\uff08\u65e5\u5e38/\u65b0\u624b\uff09", MessageBehaviorEnum.UN_JUMP, Boolean.TRUE),
    NEW_MERCHANT(16, "\u5546\u5bb6\u63d0\u4ea4\u4fe1\u606f\u6210\u529f", MessageBehaviorEnum.UN_JUMP, Boolean.FALSE),
    MERCHANT_VERIFY(18, "\u5546\u5bb6\u5ba1\u6838\u5931\u8d25", MessageBehaviorEnum.UN_JUMP, Boolean.FALSE),
    VIP_FRIEND_HELP(30, "\u7528\u6237\u6fc0\u6d3bvip\u65f6\u597d\u53cb\u52a9\u529b", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    VIP_ACTIVATION_SUCCESS(31, "\u7528\u6237\u6fc0\u6d3bvip", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    VIP_NOT_ACTIVATION(32, "\u672a\u6fc0\u6d3bVIP", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    VIP_CONTINUE_ACTIVATION(33, "\u7ee7\u7eed\u6fc0\u6d3bVIP", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    VIP_ACTIVATION(34, "\u5df2\u6fc0\u6d3bVIP", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    NEWS_REPLY(50, "\u65b0\u95fb\u56de\u590d", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    NEWS_LIKE(51, "\u65b0\u95fb\u70b9\u8d5e", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    POST_REPLY(52, "\u5e16\u5b50\u56de\u590d", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    POST_LIKE(53, "\u5e16\u5b50\u70b9\u8d5e", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    POST_REVIEW_PASS(54, "\u5e16\u5b50\u5ba1\u6838\u901a\u8fc7", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    ESSENCE_POST(55, "\u7cbe\u534e\u5e16\u901a\u77e5", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    CASH_POST(56, "\u73b0\u91d1\u5e16", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    UPDATE_GOLD(59, "\u91d1\u5e01\u53d8\u52a8(\u4e0d\u53d1\u9001\u63a8\u9001)", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    FAIL_WITHDRAW(60, "\u60a8\u7684\u5fae\u4fe1\u53f7\u672a\u5b9e\u540d\u8ba4\u8bc1\uff0c\u63d0\u73b0\u5931\u8d25", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    ADD_CASH(61, "\u65b0\u589e\u8d4f\u91d1", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    SUCCESS_WITHDRAW(62, "\u60a8\u7684\u63d0\u73b0\u5df2\u6210\u529f\u6253\u6b3e", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    USER_ACCOUNT_ENVET(90, "\u7528\u6237\u91d1\u989d\u53d8\u52a8", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    USER_UN_READ_MSG(91, "\u7528\u6237\u672a\u8bfb\u6d88\u606f\u6570\u91cf", MessageBehaviorEnum.JUMP, Boolean.FALSE);

    private int type;
    private String desc;
    private MessageBehaviorEnum behavior;
    private Boolean silence;

    private PushMessageEnum(int type, String desc, MessageBehaviorEnum behavior, Boolean silence) {
        this.type = type;
        this.desc = desc;
        this.behavior = behavior;
        this.silence = silence;
    }

    public static String getMessageDescByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() != type) continue;
            return messageEnum.getDesc();
        }
        return null;
    }

    public static String getMessageDescByType(String type) {
        return PushMessageEnum.getMessageDescByType(NumberUtils.parseToInt((String)type));
    }

    public static MessageBehaviorEnum getMessageBehaviorByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() != type) continue;
            return messageEnum.getBehavior();
        }
        return null;
    }

    public static Boolean getMessageSilenceByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() != type) continue;
            return messageEnum.getSilence();
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public MessageBehaviorEnum getBehavior() {
        return this.behavior;
    }

    public Boolean getSilence() {
        return this.silence;
    }
}

