/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.common.model.dto;

import com.bxm.localnews.mq.common.constant.PushFoldTypeEnum;
import com.bxm.localnews.mq.common.constant.PushSoundEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.BaseBean;

public class PushMessage
extends BaseBean {
    private String title;
    private String content;
    private boolean mute = false;
    private PushSoundEnum sound = PushSoundEnum.DEFAULT_SOUND;
    private TemplateTypeEnum type = TemplateTypeEnum.NOTIFCTION;
    private PushPayloadInfo payloadInfo = PushPayloadInfo.build();
    private boolean persistence = true;
    private PushReceiveScope pushReceiveScope;
    private boolean floatNotify;
    private PushFoldTypeEnum pushFoldType;
    private String notifyImageUrl;
    private String notifyText;
    private Integer periodTime = 24;
    private boolean isShock;
    private Byte actionType = 1;

    private PushMessage(String title, String content) {
        this.title = title;
        this.content = content;
    }

    private PushMessage() {
    }

    public static PushMessage build() {
        return new PushMessage();
    }

    public PushReceiveScope getPushReceiveScope() {
        return this.pushReceiveScope;
    }

    public PushMessage setPushReceiveScope(PushReceiveScope pushReceiveScope) {
        this.pushReceiveScope = pushReceiveScope;
        return this;
    }

    public boolean isShock() {
        return this.isShock;
    }

    public void setShock(boolean shock) {
        this.isShock = shock;
    }

    public Integer getPeriodTime() {
        return this.periodTime;
    }

    public void setPeriodTime(Integer periodTime) {
        this.periodTime = periodTime;
    }

    public boolean isFloatNotify() {
        return this.floatNotify;
    }

    public void setFloatNotify(boolean floatNotify) {
        this.floatNotify = floatNotify;
    }

    public PushFoldTypeEnum getPushFoldType() {
        return this.pushFoldType;
    }

    public void setPushFoldType(PushFoldTypeEnum pushFoldType) {
        this.pushFoldType = pushFoldType;
    }

    public String getNotifyImageUrl() {
        return this.notifyImageUrl;
    }

    public void setNotifyImageUrl(String notifyImageUrl) {
        this.notifyImageUrl = notifyImageUrl;
    }

    public String getNotifyText() {
        return this.notifyText;
    }

    public void setNotifyText(String notifyText) {
        this.notifyText = notifyText;
    }

    public boolean isPersistence() {
        return this.persistence;
    }

    public PushMessage setPersistence(boolean persistence) {
        this.persistence = persistence;
        return this;
    }

    public PushSoundEnum getSound() {
        return this.sound;
    }

    public PushMessage setSound(PushSoundEnum sound) {
        this.sound = sound;
        return this;
    }

    public boolean isMute() {
        return this.mute;
    }

    public PushMessage setMute(boolean mute) {
        this.mute = mute;
        return this;
    }

    public TemplateTypeEnum getType() {
        return this.type;
    }

    public PushMessage setType(TemplateTypeEnum type) {
        this.type = type;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public PushMessage setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public PushMessage setContent(String content) {
        this.content = content;
        return this;
    }

    public PushPayloadInfo getPayloadInfo() {
        if (null == this.payloadInfo) {
            this.payloadInfo = PushPayloadInfo.build();
        }
        if (StringUtils.isBlank((CharSequence)this.payloadInfo.getTitle())) {
            this.payloadInfo.setTitle(this.getTitle());
        }
        if (StringUtils.isBlank((CharSequence)this.payloadInfo.getContent())) {
            this.payloadInfo.setContent(this.getContent());
        }
        if (null != this.getSound()) {
            this.payloadInfo.setSound(this.getSound().name());
        }
        return this.payloadInfo;
    }

    public PushMessage setPayloadInfo(PushPayloadInfo payloadInfo) {
        this.payloadInfo = null == payloadInfo ? PushPayloadInfo.build() : payloadInfo;
        return this;
    }

    public Byte getActionType() {
        return this.actionType;
    }

    public void setActionType(Byte actionType) {
        this.actionType = actionType;
    }

    public boolean valid() {
        return this.pushReceiveScope != null && this.payloadInfo != null;
    }
}

