/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.common.util;

import com.bxm.localnews.common.util.MD5Sign;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SHASign {
    public static String sign(HashMap<String, String> params, String secret) {
        StringBuilder valueSb = new StringBuilder();
        TreeMap<String, String> sortParams = new TreeMap<String, String>(params);
        Set entrys = sortParams.entrySet();
        for (Map.Entry entry : entrys) {
            valueSb.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("&");
        }
        valueSb.deleteCharAt(valueSb.length() - 1);
        String md5Str = MD5Sign.md5(valueSb.toString()).toUpperCase();
        return SHASign.sha256_HMAC(md5Str, secret).toUpperCase();
    }

    private static String sha256_HMAC(String message, String secret) {
        String hash = "";
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(secret.getBytes(), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] bytes = sha256_HMAC.doFinal(message.getBytes());
            hash = SHASign.byteArrayToHexString(bytes);
        }
        catch (Exception e) {
            System.out.println("Error HmacSHA256 ===========" + e.getMessage());
        }
        return hash;
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toLowerCase();
    }
}

