package com.bxm.localnews.common.constant;

/**
 * 广告素材类型
 * @Author: Gonzo
 * @Date 2020-01-17 11:17
 */
public enum  AdvertMaterialType {
    /**
     * 文字
     */
    TEXT("文字", 1),

    /**
     * 图片
     */
    IMAGE("图片", 2),

    /**
     * 任务素材
     */
    TASK("任务素材", 3),

    /**
     * 小程序客服
     */
    MINI_APP("小程序客服", 4),

    /**
     * 小程序分享
     */
    MINI_APP_SHARE("小程序分享", 5),

    /**
     * 变现猫ssp
     */
    BXM_SSP_ADVERT("变现猫SSP", 6),
    ;

    private String name;

    private int type;

    AdvertMaterialType(String name, int type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public int getType() {
        return type;
    }
}
