package com.bxm.component.mq.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author lowi
 * @date 2021/5/24 17:06
 */
@ConfigurationProperties(prefix = "component.rabbit.channel")
@Data
@Component
public class RabbitConfigurationProperties {

    /**
     * 交换器的类型，常见的有direct,fanout,topic等
     */
    private String type = "direct";

    /**
     * 设置是否持久化。durable设置为true时表示持久化，反之非持久化.持久化可以将交换器存入磁盘，
     * 在服务器重启的时候不会丢失相关信息。
     */
    private Boolean durable = true;

    /**
     * 设置是否自动删除。autoDelete设置为true时，则表示自动删除。
     * 自动删除的前提是至少有一个队列或者交换器与这个交换器绑定，之后，
     * 所有与这个交换器绑定的队列或者交换器都与此解绑。
     * 不能错误的理解—当与此交换器连接的客户端都断开连接时，RabbitMq会自动删除本交换器
     */
    private Boolean autoDelete = false;

    /**
     * 设置是否内置的。如果设置为true，则表示是内置的交换器，
     * 客户端程序无法直接发送消息到这个交换器中，只能通过交换器路由到交换器这种方式
     */
    private Boolean internal = false;

    /**
     * 其它一些结构化的参数，比如：alternate-exchange
     */
    private Map<String, Object> arguments = null;

    /**
     * 是否排外的，有两个作用，一：当连接关闭时connection.close()该队列是否会自动删除；
     * 二：该队列是否是私有的private，如果不是排外的，可以使用两个消费者都访问同一个队列，
     * 没有任何问题，如果是排外的，会对当前队列加锁，
     * 其他通道channel是不能访问的，
     * 如果强制访问会报异常：com.rabbitmq.client.ShutdownSignalException:
     * channel error; protocol method: #method<channel.close>(reply-code=405,
     * reply-text=RESOURCE_LOCKED - cannot obtain exclusive access to locked queue
     * 'queue_name' in vhost '/', class-id=50, method-id=20)
     * 一般等于true的话用于一个队列只能有一个消费者来消费的场景
     */
    private Boolean exclusive = false;


}
