/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.mq.message.listener.rabbit;

import com.bxm.component.mq.MessageConsumer;
import com.bxm.component.mq.conditionals.MessageConditionalOnProperty;
import com.bxm.component.mq.config.RabbitConfigurationProperties;
import com.bxm.component.mq.enums.MessageTypeEnum;
import com.bxm.component.mq.message.listener.rabbit.ConcreteRabbitConsumer;
import com.bxm.newidea.component.tools.ReflectionUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
@MessageConditionalOnProperty(type=MessageTypeEnum.RABBIT_MQ)
public class RabbitMqEventListener
implements ApplicationRunner,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(RabbitMqEventListener.class);
    private final ConnectionFactory connectionFactory;
    private final RabbitConfigurationProperties configurationProperties;
    private ApplicationContext applicationContext;

    public void run(ApplicationArguments args) {
        Map subscriberMap = this.applicationContext.getBeansOfType(MessageConsumer.class);
        for (MessageConsumer subscriber : subscriberMap.values()) {
            Class subscriberValueClass = ReflectionUtils.getFirstGenericType(subscriber.getClass());
            if (null == subscriberValueClass) {
                log.error("\u58f0\u660e\u7684[{}]\u6ca1\u6709\u6307\u5b9a\u6cdb\u578b\uff0c\u65e0\u6cd5\u5339\u914d\u8ba2\u9605\u6570\u636e", (Object)subscriber.getClass().getSimpleName());
                continue;
            }
            Method method = null;
            try {
                method = subscriber.getClass().getMethod("uniqueMark", new Class[0]);
                Object uniqueMark = method.invoke(subscriber.getClass().newInstance(), new Object[0]);
                if (Objects.isNull(uniqueMark) || StringUtils.isBlank((CharSequence)((String)uniqueMark))) {
                    log.error("\u58f0\u660e\u7684[{}]\u6ca1\u6709\u6307\u5b9a\u6cdb\u578b\uff0c\u65e0\u6cd5\u5339\u914d\u8ba2\u9605\u6570\u636e", (Object)subscriber);
                    continue;
                }
                this.setQueueChannel((String)uniqueMark, subscriber, subscriberValueClass);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void setQueueChannel(String uniqueMark, MessageConsumer subscriber, Class<?> className) {
        Connection connection = this.connectionFactory.createConnection();
        Channel channel = connection.createChannel(false);
        String exchange = uniqueMark + "-exchange";
        String routingKey = uniqueMark + "-routing";
        try {
            channel.exchangeDeclare(exchange, this.configurationProperties.getType(), this.configurationProperties.getDurable().booleanValue(), this.configurationProperties.getAutoDelete().booleanValue(), this.configurationProperties.getArguments());
            channel.queueDeclare(uniqueMark, this.configurationProperties.getDurable().booleanValue(), this.configurationProperties.getExclusive().booleanValue(), this.configurationProperties.getAutoDelete().booleanValue(), this.configurationProperties.getArguments());
            channel.queueBind(uniqueMark, exchange, routingKey);
            channel.basicConsume(uniqueMark, true, new ConcreteRabbitConsumer(channel, subscriber, className, exchange));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public RabbitMqEventListener(ConnectionFactory connectionFactory, RabbitConfigurationProperties configurationProperties, ApplicationContext applicationContext) {
        this.connectionFactory = connectionFactory;
        this.configurationProperties = configurationProperties;
        this.applicationContext = applicationContext;
    }
}

