package com.bxm.component.mq.message.send.impl;

import com.bxm.component.mq.MessageSender;
import com.bxm.component.mq.config.MessageConfigurationProperties;
import com.bxm.component.mq.message.send.impl.strategy.MessageContextProcess;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author lowi
 * @date 2021/8/18 10:22
 */
@Service
@Slf4j
public class MessageSenderImpl<T> implements MessageSender<T> {

    @Autowired
    private MessageConfigurationProperties configurationProperties;

    @Autowired
    private MessageContextProcess<T> messageContextProcess;

    @Override
    public void send(String uniqueMark, T message) {
        //根据配置不同的消费客户端，发送消息
        messageContextProcess.sendMessage(configurationProperties.getMessageType(), uniqueMark, message);
    }
}
