package com.bxm.component.mq.message.send.impl.strategy;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;

/**
 * @author lowi
 * @date 2021/8/18 10:10
 */
@Component
public class MessageContextProcess<T> {

    private HashMap<String, MessageStrategy<T>> strategyHashMap;


    public MessageContextProcess(List<MessageStrategy<T>> strategies) {
        strategyHashMap = new HashMap<>((int) (strategies.size() / .75f) + 1);
        strategies.forEach(entity -> strategyHashMap.put(entity.getType(), entity));
    }


    public void sendMessage(String type, String uniqueMark, T message) {
        strategyHashMap.get(type).sendMessage(uniqueMark, message);
    }

}
