package com.bxm.component.bus.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author liujia
 * @date 11/29/21 7:42 PM
 **/
@ConfigurationProperties(prefix = "component.event-bus")
@Data
public class ComponentBusConfigurationProperties {

    /**
     * 异步事件总线默认的核心线程数量
     */
    private Integer corePoolSize = Runtime.getRuntime().availableProcessors() * 2 + 1;

    /**
     * 异步线程处理执行被拒绝时的处理策略
     * 取值参考ThreadPoolExecutor中提供的四种默认是吸纳
     */
    private String executorRejectHandlerPolicy = "CallerRunsPolicy";
}
