package com.bxm.component.cache.controller;

import com.bxm.component.cache.dto.CacheSubDataDTO;
import com.bxm.component.cache.param.CacheFetchParam;
import com.bxm.component.cache.param.CacheRemoveParam;
import com.bxm.component.cache.service.ExposeSyncCacheService;
import com.bxm.newidea.component.sync.monitor.CacheStatusBO;
import com.bxm.newidea.component.vo.ResponseJson;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/expose/sync-cache")
@AllArgsConstructor
public class ExposeController {

    private final ExposeSyncCacheService exposeSyncCacheService;

    /**
     * 拉取当前实例下的缓存信息
     *
     * @return 缓存键值列表
     */
    @GetMapping("fetch/key")
    public ResponseJson<List<CacheStatusBO>> fetchKeyList() {
        return ResponseJson.ok(exposeSyncCacheService.fetchKey());
    }

    @GetMapping("fetch/data")
    public ResponseJson<List<CacheSubDataDTO>> fetchData(CacheFetchParam param) {
        return ResponseJson.ok(exposeSyncCacheService.fetchSubKey(param));
    }

    /**
     * 清理缓存分组或者具体的缓存
     *
     * @param param 移除参数，支持分组移除，也支持单个缓存移除
     * @return 清理结果
     */
    @PostMapping("clear")
    public ResponseJson<?> clear(@RequestBody CacheRemoveParam param) {
        return ResponseJson.build(exposeSyncCacheService.clear(param));
    }
}
