package com.bxm.component.cache.service;

import com.bxm.component.cache.dto.CacheSubDataDTO;
import com.bxm.component.cache.param.CacheFetchParam;
import com.bxm.component.cache.param.CacheRemoveParam;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.sync.key.SyncCacheKey;
import com.bxm.newidea.component.sync.monitor.CacheStatusBO;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

@Service
@AllArgsConstructor
@Slf4j
public class ExposeSyncCacheService {

    public static final long MAX_CACHE_DATA = 20000L;

    private CacheHolder cacheHolder;

    public List<CacheStatusBO> fetchKey() {
        return cacheHolder.getMonitorInfo();
    }

    public List<CacheSubDataDTO> fetchSubKey(CacheFetchParam param) {
        List<CacheSubDataDTO> cacheResultData = Lists.newArrayList();
        if (StringUtils.isBlank(param.getCacheKey())) {
            return cacheResultData;
        }

        SyncCacheKey queryKey = SyncCacheKey.builder(param.getCacheKey(), null).build();
        if (StringUtils.isNotBlank(param.getSubKey())) {
            Object data = cacheHolder.get(queryKey, param.getSubKey());
            CacheSubDataDTO cacheSubDataDTO = new CacheSubDataDTO();
            cacheSubDataDTO.setKey(param.getCacheKey());
            cacheSubDataDTO.setSubKey(param.getSubKey());
            cacheSubDataDTO.setData(JSON.toJSONString(data));
            cacheResultData.add(cacheSubDataDTO);
            return cacheResultData;
        }

        CacheStatusBO monitor = cacheHolder.getMonitorInfo(queryKey);

        // 数据过多的就不查询显示了
        if (monitor.getSize() > MAX_CACHE_DATA) {
            return cacheResultData;
        }

        ConcurrentMap<String, Object> allMap = cacheHolder.getAllMap(queryKey);

        int limit = 20;
        for (Map.Entry<String, Object> entry : allMap.entrySet()) {
            if (limit <= 0) {
                break;
            }
            CacheSubDataDTO cacheSubDataDTO = new CacheSubDataDTO();
            cacheSubDataDTO.setKey(param.getCacheKey());
            cacheSubDataDTO.setSubKey(entry.getKey());
            cacheSubDataDTO.setData(JSON.toJSONString(entry.getValue()));
            cacheResultData.add(cacheSubDataDTO);
            limit--;
        }

        return cacheResultData;
    }

    public Message clear(CacheRemoveParam param) {
        SyncCacheKey removeKey = SyncCacheKey.builder(param.getCacheKey(), null).build();

        if (param.getSubKey() != null && param.getCacheKey() != null) {
            log.info("[sync-cache]清理缓存，key:{},subKey:{}", param.getCacheKey(), param.getSubKey());
            cacheHolder.evict(removeKey, param.getSubKey());
        } else {
            log.info("[sync-cache]清理缓存分组，key:{}", param.getCacheKey());
            cacheHolder.sendClearCmd(removeKey);
        }
        return Message.build();
    }
}























