package com.bxm.newidea.component.sync.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * BCache配置文件读取
 *
 * @author wzy
 * @date 2020年12月18日11:51:31
 */
@Data
@ConfigurationProperties("second.level.config")
public class SecondLevelCacheConfig {

    /**
     * 二级缓存类型，默认guava
     */
    private String cacheIndent = "guava";

    /**
     * 广播方式
     */
    private String broadcast;

    /**
     * 事件发送模板url
     */
    private String envTemplateUrl = "http://localhost:%s%s/actuator/bus-env";

    /**
     * 缓存更改事件名称
     */
    private String envName = "secondLevelCache";

    private String contextPath;
}
