/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.cluster;

import com.alibaba.fastjson.JSON;
import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.newidea.component.sync.cluster.ClusterPolicy;
import com.bxm.newidea.component.sync.cluster.Command;
import com.bxm.newidea.component.sync.config.SecondLevelCacheConfig;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class SpringEventBusClusterPolicy
implements ClusterPolicy {
    private static final Logger log = LoggerFactory.getLogger(SpringEventBusClusterPolicy.class);
    private final SecondLevelCacheConfig secondLevelCacheConfig;
    private static final String DEFAULT_SERVER_PORT = "8080";
    private static final String EMPTY_STRING = "";
    private static final String PATH_SEPARATOR = "/";
    @Value(value="${server.port:8080}")
    private String port;
    @Value(value="${server.servlet.context-path:/}")
    private String contextPath;

    public SpringEventBusClusterPolicy(SecondLevelCacheConfig secondLevelCacheConfig) {
        this.secondLevelCacheConfig = secondLevelCacheConfig;
    }

    @Override
    public String name() {
        return "eventBus";
    }

    @Override
    public void publish(Command command) {
        String envUrl = this.getEnvUrl();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", this.secondLevelCacheConfig.getEnvName());
        params.put("value", JSON.toJSONString((Object)command));
        String response = OkHttpUtils.postJsonBody((String)envUrl, (String)JSON.toJSONString(params), null);
        log.info("info: {}", (Object)response);
    }

    private String getEnvUrl() {
        String envUrl = this.secondLevelCacheConfig.getEnvTemplateUrl();
        String finalPort = this.port;
        String finalContextPath = this.contextPath;
        if (StringUtils.isBlank((CharSequence)this.port)) {
            finalPort = DEFAULT_SERVER_PORT;
        }
        if (StringUtils.isBlank((CharSequence)finalContextPath)) {
            finalContextPath = EMPTY_STRING;
        } else {
            if (!finalContextPath.startsWith(PATH_SEPARATOR)) {
                finalContextPath = PATH_SEPARATOR + finalContextPath;
            }
            if (finalContextPath.endsWith(PATH_SEPARATOR)) {
                finalContextPath = finalContextPath.substring(0, finalContextPath.length() - 1);
            }
        }
        envUrl = String.format(envUrl, finalPort, finalContextPath);
        return envUrl;
    }
}

