package com.bxm.newidea.component.sync.config;

import com.bxm.newidea.component.sync.cluster.impl.SpringEventBusClusterPolicy;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bus.ConditionalOnBusEnabled;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 二级缓存同步组件的装配
 *
 * @author liujia
 * @date 1/22/21 10:10 AM
 **/
@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties(SecondLevelCacheConfig.class)
public class CacheSyncConfiguration {

    @Bean
    @ConditionalOnBusEnabled
    public SpringEventBusClusterPolicy springEventBusClusterPolicy(SecondLevelCacheConfig config) {
        return new SpringEventBusClusterPolicy(config);
    }
}
