/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.core;

import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.sync.key.SyncCacheKey;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheHolderBuilder {
    private static final Logger log = LoggerFactory.getLogger(CacheHolderBuilder.class);
    private SyncCacheKey keyGenerator;
    private Function cacheLoader;
    private long maximumSize = 1000L;
    private long duration = 60L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private CacheHolder cacheHolder;

    CacheHolderBuilder(CacheHolder cacheHolder) {
        this.cacheHolder = cacheHolder;
    }

    public CacheHolderBuilder keyGenerator(SyncCacheKey keyGenerator) {
        this.keyGenerator = keyGenerator;
        return this;
    }

    public <T, R> CacheHolderBuilder cacheLoader(Function<T, R> cacheLoader) {
        this.cacheLoader = cacheLoader;
        return this;
    }

    public CacheHolderBuilder maximumSize(long maximumSize) {
        this.maximumSize = maximumSize;
        return this;
    }

    public CacheHolderBuilder duration(long duration) {
        this.duration = duration;
        return this;
    }

    public CacheHolderBuilder timeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        return this;
    }

    public CacheHolder build() {
        if (null == this.keyGenerator) {
            log.error("\u7f13\u5b58\u952e\u503c\u5fc5\u987b\u6307\u5b9a");
        }
        if (this.cacheLoader == null) {
            log.info("[{}]\u672a\u6307\u5b9a\u7f13\u5b58\u6570\u636e\u52a0\u8f7d\u6765\u6e90", (Object)this.keyGenerator);
        }
        this.cacheHolder.set(this.keyGenerator, this.cacheLoader, this.maximumSize, this.timeUnit, this.duration);
        return this.cacheHolder;
    }
}

