/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.core;

import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.sync.key.SyncCacheKey;
import com.bxm.newidea.component.sync.monitor.SyncCacheMeterBinder;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public abstract class AbstractSyncCacheProvider<K, D>
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(AbstractSyncCacheProvider.class);
    @Resource
    private CacheHolder cacheHolder;
    @Resource
    private SyncCacheMeterBinder meterBinder;
    private ThreadLocal<K> threadLocal = new ThreadLocal();

    public void run(ApplicationArguments args) throws Exception {
        if (null == this.key()) {
            throw new IllegalArgumentException("#key()\u65b9\u6cd5\u5fc5\u987b\u8fd4\u56de\u503c");
        }
        this.cacheHolder.set(this.key(), new Function<String, D>(){

            @Override
            public D apply(String s) {
                return AbstractSyncCacheProvider.this.load(AbstractSyncCacheProvider.this.threadLocal.get());
            }
        });
        this.meterBinder.bind(this.key());
        log.info("\u521d\u59cb\u5316\u5185\u5b58\u7f13\u5b58\uff0cgroup\u4e3a\uff1a{}", (Object)this.key());
    }

    protected abstract D load(K var1);

    protected abstract SyncCacheKey key();

    protected abstract String toKeyString(K var1);

    public void put(K subKey, D data) {
        this.cacheHolder.set(this.key(), this.toKeyString(subKey), data);
    }

    public D get(K subKey) {
        String keyString = this.toKeyString(subKey);
        this.threadLocal.set(subKey);
        Object data = this.cacheHolder.get(this.key(), keyString);
        this.threadLocal.remove();
        return (D)data;
    }

    public Collection<D> getAll() {
        ConcurrentMap allMap = this.cacheHolder.getAllMap(this.key());
        if (null != allMap) {
            return allMap.values();
        }
        return Lists.newArrayList();
    }

    public void remove(K subKey) {
        String decodeSubKey = this.toKeyString(subKey);
        this.cacheHolder.evict(this.key(), decodeSubKey);
        this.cacheHolder.sendEvictCmd(this.key(), decodeSubKey);
    }

    public void removeAll() {
        this.cacheHolder.clear(this.key());
        this.cacheHolder.sendClearCmd(this.key());
        log.info("{}\u6e05\u7406\u5168\u90e8\u7f13\u5b58", (Object)this.key());
    }
}

