/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.monitor;

import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.sync.key.SyncCacheKey;
import com.bxm.newidea.component.sync.monitor.param.ClearParam;
import com.bxm.newidea.component.sync.monitor.param.EvictParam;
import com.bxm.newidea.component.vo.ResponseJson;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/second/cache/manage"})
@RestController
public class ManageCacheController {
    private final CacheHolder cacheHolder;

    public ManageCacheController(CacheHolder cacheHolder) {
        this.cacheHolder = cacheHolder;
    }

    @PostMapping(value={"evict"})
    public ResponseJson evict(@RequestBody EvictParam evictParam) {
        this.cacheHolder.evict(SyncCacheKey.build(evictParam.getGroupName(), evictParam.getKey()), evictParam.getSubKey());
        return ResponseJson.ok().build();
    }

    @PostMapping(value={"clear"})
    public ResponseJson clear(@RequestBody ClearParam param) {
        this.cacheHolder.clear(SyncCacheKey.build(param.getGroupName(), param.getKey()));
        return ResponseJson.ok().build();
    }

    @PostMapping(value={"clearGroup"})
    public ResponseJson clearGroup(@RequestBody ClearParam param) {
        this.cacheHolder.clearGroup(param.getGroupName());
        return ResponseJson.ok().build();
    }

    @GetMapping(value={"allGroup"})
    public ResponseJson<List<String>> getAllGroup() {
        return ResponseJson.ok(this.cacheHolder.getAllGroup());
    }

    @GetMapping(value={"detail"})
    public ResponseJson get(@RequestParam(value="group") String group, @RequestParam(value="key") String key) {
        ConcurrentMap allMap = this.cacheHolder.getAllMap(SyncCacheKey.build(group, key));
        if (CollectionUtils.isEmpty(allMap)) {
            return ResponseJson.ok((Object)Collections.EMPTY_MAP);
        }
        return ResponseJson.ok(allMap);
    }
}

