/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.provider.guava;

import com.bxm.newidea.component.sync.constants.ExpiredStrategyEnum;
import com.bxm.newidea.component.sync.key.SyncCacheKey;
import com.bxm.newidea.component.sync.monitor.MonitorCacheVO;
import com.bxm.newidea.component.sync.provider.CacheProvider;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaLoaderProvider
implements CacheProvider {
    private static final Logger log = LoggerFactory.getLogger(GuavaLoaderProvider.class);
    private Map<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private Map<String, Function> loaderMap = new ConcurrentHashMap<String, Function>();
    private static final long DEFAULT_EXPIRED_TIME = 1800L;

    private <R> Cache<String, R> newGuavaCache(SyncCacheKey keyGenerator) {
        if (ExpiredStrategyEnum.AFTER_WRITE.equals((Object)keyGenerator.getExpiredStrategy())) {
            return CacheBuilder.newBuilder().recordStats().maximumSize(keyGenerator.getMaximumSize()).expireAfterWrite(keyGenerator.getDuration(), keyGenerator.getTimeUnit()).build();
        }
        return CacheBuilder.newBuilder().recordStats().maximumSize(keyGenerator.getMaximumSize()).expireAfterAccess(keyGenerator.getDuration(), keyGenerator.getTimeUnit()).build();
    }

    @Override
    public <R> void set(SyncCacheKey keyGenerator, Function<String, R> cacheLoader) {
        this.caches.putIfAbsent(keyGenerator.gen(), this.newGuavaCache(keyGenerator));
        if (!this.loaderMap.containsKey(keyGenerator.gen())) {
            this.loaderMap.put(keyGenerator.gen(), cacheLoader);
        }
    }

    @Override
    public <V> Map<String, V> get(SyncCacheKey keyGenerator, Collection<String> subKeys) {
        Cache loadingCache = this.caches.get(keyGenerator.gen());
        if (Objects.isNull(loadingCache)) {
            return null;
        }
        HashMap result = Maps.newHashMap();
        for (String subKey : subKeys) {
            result.put(subKey, this.get(keyGenerator, subKey));
        }
        return result;
    }

    @Override
    public <V> V get(SyncCacheKey keyGenerator, String subKey) {
        Cache loadingCache = this.caches.get(keyGenerator.gen());
        if (Objects.isNull(loadingCache)) {
            return null;
        }
        Object value = loadingCache.getIfPresent((Object)subKey);
        if (null == value) {
            value = this.loaderMap.get(keyGenerator.gen()).apply(subKey);
            loadingCache.put((Object)subKey, value);
        }
        return (V)value;
    }

    @Override
    public <V> void set(SyncCacheKey keyGenerator, String subKey, V value) {
        Cache loadingCache = this.caches.get(keyGenerator.gen());
        if (Objects.isNull(loadingCache) || subKey == null || value == null) {
            return;
        }
        loadingCache.put((Object)subKey, value);
    }

    @Override
    public <V> boolean exists(SyncCacheKey keyGenerator, String subKey) {
        Cache loadingCache = this.caches.get(keyGenerator.gen());
        if (Objects.isNull(loadingCache) || null == subKey) {
            return false;
        }
        return Objects.nonNull(loadingCache.getIfPresent((Object)subKey));
    }

    @Override
    public <V> void set(SyncCacheKey keyGenerator, Map<String, V> elements) {
        Cache loadingCache = this.caches.get(keyGenerator.gen());
        if (Objects.isNull(loadingCache) || null == elements) {
            return;
        }
        elements.forEach((arg_0, arg_1) -> ((Cache)loadingCache).put(arg_0, arg_1));
    }

    @Override
    public <V> void evict(SyncCacheKey keyGenerator, String ... subKeys) {
        Cache loadingCache = this.caches.get(keyGenerator.gen());
        if (Objects.isNull(loadingCache) || null == subKeys || subKeys.length == 0) {
            return;
        }
        ArrayList subKeyHashList = Lists.newArrayList();
        subKeyHashList.addAll(Arrays.asList(subKeys));
        loadingCache.invalidateAll((Iterable)subKeyHashList);
    }

    @Override
    public <V> void clear(SyncCacheKey keyGenerator) {
        Cache loadingCache = this.caches.get(keyGenerator.gen());
        if (Objects.isNull(loadingCache)) {
            return;
        }
        loadingCache.invalidateAll();
    }

    @Override
    public boolean existsCache(SyncCacheKey keyGenerator) {
        return this.caches.get(keyGenerator.gen()) != null;
    }

    @Override
    public List<MonitorCacheVO> getMonitorInfo() {
        ArrayList<MonitorCacheVO> monitorCacheVOList = new ArrayList<MonitorCacheVO>();
        this.caches.forEach((k, v) -> {
            CacheStats cacheStats = v.stats();
            MonitorCacheVO cacheVO = new MonitorCacheVO();
            cacheVO.setCacheName((String)k);
            cacheVO.setHintCount(cacheStats.hitCount());
            cacheVO.setMissCount(cacheStats.missCount());
            cacheVO.setHintRate(cacheStats.hitRate());
            cacheVO.setEvictionCount(cacheStats.evictionCount());
            cacheVO.setLoadSuccessCount(cacheStats.loadExceptionCount());
            cacheVO.setLoadExceptionCount(cacheStats.loadSuccessCount());
            cacheVO.setTotalLoadTime(cacheStats.totalLoadTime());
            cacheVO.setRequestCount(cacheStats.requestCount());
            cacheVO.setSize(v.size());
            monitorCacheVOList.add(cacheVO);
        });
        return monitorCacheVOList;
    }

    @Override
    public void clearGroup(String groupName) {
        this.caches.forEach((k, v) -> {
            String[] keys = k.split(":");
            String targetGroupName = keys[0];
            if (Objects.equals(targetGroupName, groupName)) {
                v.invalidateAll();
            }
        });
    }

    @Override
    public List<String> getAllGroup() {
        HashSet groupNameSet = new HashSet();
        this.caches.forEach((k, v) -> {
            String[] keys = k.split(":");
            String targetGroupName = keys[0];
            groupNameSet.add(targetGroupName);
        });
        ArrayList<String> resultList = new ArrayList<String>(groupNameSet);
        resultList.sort(String::compareTo);
        return resultList;
    }

    @Override
    public <V> ConcurrentMap<String, V> getAllMap(SyncCacheKey keyGenerator) {
        Cache loadingCache = this.caches.get(keyGenerator.gen());
        if (Objects.isNull(loadingCache)) {
            return null;
        }
        return loadingCache.asMap();
    }
}

