package com.bxm.demo;

import com.bxm.newidea.component.sync.constants.BroadcastStrategyEnum;
import com.bxm.newidea.component.sync.core.SyncCacheAgent;
import com.bxm.newidea.component.sync.core.SyncCacheHolderFactory;
import com.bxm.newidea.component.sync.key.SyncCacheKey;
import com.bxm.newidea.component.tools.RandomUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

/**
 * @author liujia
 * @date 10/27/21 9:20 PM
 **/
@Component
@Slf4j
public class RefreshCacheDemo implements ApplicationRunner {

    private static final SyncCacheKey KEY = SyncCacheKey.builder("group", "hizz")
            .maximumSize(1000)
            .timeUnit(TimeUnit.MINUTES)
            .duration(1)
            .expiredAfterWrite()
            .broadcastStrategy(BroadcastStrategyEnum.SERVER)
            .build();

    public void randomCache() {
        SyncCacheAgent<Long, MockBean> cacheAgent = SyncCacheHolderFactory.build(KEY, (i) -> {
            MockBean bean = new MockBean();
            bean.setId(i);
            bean.setName(i + "i");
            return bean;
        });

        MockBean value = cacheAgent.get(RandomUtils.nextLong(0, 100000));

        if (value.getId() % 5 == 0) {
            cacheAgent.sendClearCmd();
        } else if (value.getId() % 3 == 0) {
            cacheAgent.sendEvictCmd(value);
        }
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(
                this::randomCache, 0, 3, TimeUnit.SECONDS
        );
    }
}
