package com.bxm.newidea.component.tools;

import java.security.MessageDigest;

public class MD5Util {

    private static final String SALT = "gotohell";

    /**
     * 进行密码加密，会使用默认的盐值
     * @param password 原始密码
     * @return 加密后的字符串
     */
    public static String encodePwd(String password) {
        return encode(password, SALT);
    }

    /**
     * 对source进行md5加密
     * @param source 元素字符串
     * @return 加密后的字符串
     */
    public static String encode(String source) {
        return encode(source, null);
    }

    /**
     * 对字符串进行md5加密
     * @param source 原始字符串
     * @param salt   加密盐值
     * @return 加密后的结果
     */
    public static String encode(String source, String salt) {
        source = source + salt;
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        char[] charArray = source.toCharArray();
        byte[] byteArray = new byte[charArray.length];

        for (int i = 0; i < charArray.length; i++) {
            byteArray[i] = (byte) charArray[i];
        }
        byte[] md5Bytes = md5.digest(byteArray);
        StringBuilder hexValue = new StringBuilder();
        for (byte md5Byte : md5Bytes) {
            int val = ((int) md5Byte) & 0xff;
            if (val < 16) {
                hexValue.append("0");
            }

            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    /**
     * 黄瓜头条中使用的MD5加密方式
     * @param data 加密的原数据
     * @return 加密后的结果
     * @deprecated 不推荐使用, 保证原程序的兼容性，部分地方仍然在用
     */
    public static String hgmd5(String data) {
        try {
            StringBuilder buf = new StringBuilder();
            MessageDigest digest = MessageDigest.getInstance("MD5");

            for (byte b : digest.digest(data.getBytes("utf8"))) {
                buf.append(String.format("%02x", b & 0xff));
            }
            return buf.toString();
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 进行MD5加密
     * @param key 加密前的字符串
     * @return 加密结果
     */
    public static String md5(String key) {
        char hexDigits[] = {
                '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
        };
        try {
            byte[] btInput = key.getBytes();
            // 获得MD5摘要算法的 MessageDigest 对象
            MessageDigest digest = MessageDigest.getInstance("MD5");
            // 使用指定的字节更新摘要
            digest.update(btInput);
            // 获得密文
            byte[] md = digest.digest();
            // 把密文转换成十六进制的字符串形式
            int j = md.length;
            char str[] = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; i++) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xf];
                str[k++] = hexDigits[byte0 & 0xf];
            }
            return new String(str);
        } catch (Exception e) {
            return null;
        }
    }
}