package com.bxm.newidea.component.tools;


import java.util.Random;

/**
 * 随机相关的工具类
 * @author liujia 2018/4/28 15:23
 */
public class RandomUtils extends org.apache.commons.lang3.RandomUtils {

    private static char[] SHORT_CODE = "0123456789".toCharArray();

    /**
     * 获取一个纯数字的随机字符串
     * @param length 生成字符串长度
     * @return 生成结果
     */
    public static String getShortCode(int length) {
        StringBuilder strValue = new StringBuilder();
        for (int i = 0; i < length; i++) {
            int index = nextInt(0, length);
            strValue.append(SHORT_CODE[index]);
        }
        return strValue.toString();
    }

    /**
     * 获得一个随机的字符串
     * @param length 随机字符串的长度
     * @param noCase true表示不区分大小写
     * @return 随机字符串
     */
    public static String getRandomStr(int length, boolean noCase) {
        StringBuilder randomStr = new StringBuilder();

        char[] samplerArray = noCase ? StringUtils.DIGITS_NOCASE : StringUtils.DIGITS;
        int randSeed = samplerArray.length;

        for (int i = 0; i < length; i++) {
            randomStr.append(samplerArray[nextInt(0, randSeed)]);
        }

        return randomStr.toString();
    }

    public static Integer getRandomTime(String str) {
        if (StringUtils.isEmpty(str)) {
            return 0;
        } else {
            String[] array = str.split("~");
            Random random = new Random();
            Integer interval = random.nextInt(Integer.valueOf(array[1]) - Integer.valueOf(array[0]) + 1) + Integer.valueOf(array[0]);
            return interval;
        }
    }
}
