/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.tools;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    public static final char[] DIGITS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    public static final char[] DIGITS_NOCASE = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final Pattern CRLF_PATTERN = Pattern.compile("\\r|\\n|\\r\\n");

    private StringUtils() {
    }

    public static String bytesToString(byte[] bytes) {
        return StringUtils.bytesToString(bytes, false);
    }

    public static String bytesToString(byte[] bytes, boolean noCase) {
        char[] digits = noCase ? DIGITS_NOCASE : DIGITS;
        int digitsLength = digits.length;
        if (ArrayUtils.isEmpty((byte[])bytes)) {
            return String.valueOf(digits[0]);
        }
        StringBuilder strValue = new StringBuilder();
        int value = 0;
        int limit = 0x7FFFFF;
        int i = 0;
        while (true) {
            if (i < bytes.length && value < limit) {
                value = (value << 8) + (0xFF & bytes[i++]);
                continue;
            }
            while (value >= digitsLength) {
                strValue.append(digits[value % digitsLength]);
                value /= digitsLength;
            }
            if (i >= bytes.length) break;
        }
        if (value != 0 || strValue.length() == 0) {
            strValue.append(digits[value]);
        }
        return strValue.toString();
    }

    public static String longToString(long longValue) {
        return StringUtils.longToString(longValue, false);
    }

    public static String longToString(long longValue, boolean noCase) {
        char[] digits = noCase ? DIGITS_NOCASE : DIGITS;
        int digitsLength = digits.length;
        if (longValue == 0L) {
            return String.valueOf(digits[0]);
        }
        if (longValue < 0L) {
            longValue = -longValue;
        }
        StringBuilder strValue = new StringBuilder();
        while (longValue != 0L) {
            int digit = (int)(longValue % (long)digitsLength);
            longValue /= (long)digitsLength;
            strValue.append(digits[digit]);
        }
        return strValue.toString();
    }

    public static String stringConcat(String s1, String s2) {
        String result = "";
        if (null != s1) {
            result = result + s1;
        }
        if (null != s2) {
            result = result + s2;
        }
        return result;
    }

    public static boolean notEquals(CharSequence cs1, CharSequence cs2) {
        return !StringUtils.equals((CharSequence)cs1, (CharSequence)cs2);
    }

    public static boolean notEqualsIgnoreCase(CharSequence cs1, CharSequence cs2) {
        return !StringUtils.equalsIgnoreCase((CharSequence)cs1, (CharSequence)cs2);
    }

    public static String codes62(int num) {
        int num1 = num / 3844 % 62;
        int num2 = num / 62 % 62;
        int num3 = num % 62;
        String numOne = String.valueOf(DIGITS).charAt(num1) + "";
        String numTwo = String.valueOf(DIGITS).charAt(num2) + "";
        String numThree = String.valueOf(DIGITS).charAt(num3) + "";
        return numOne + numTwo + numThree;
    }

    public static String convertMessage(String template, Map<String, String> param) {
        if (template != null && param != null && !param.isEmpty()) {
            for (Map.Entry<String, String> entry : param.entrySet()) {
                template = template.replace("{" + entry.getKey() + "}", entry.getValue());
            }
        }
        return template;
    }

    public static String hideMobile(String mobile) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)mobile) && mobile.length() > 6) {
            for (int i = 0; i < mobile.length(); ++i) {
                char c = mobile.charAt(i);
                if (i >= 3 && i <= 6) {
                    sb.append('*');
                    continue;
                }
                sb.append(c);
            }
        }
        return sb.toString();
    }
}

