/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.tools;

import com.bxm.newidea.component.tools.DateUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NumberUtils.class);
    private static final String[] CN_UPPER_NUMBER = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CN_UPPER_MONETRAY_UNIT = new String[]{"\u5206", "\u89d2", "\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u5146", "\u62fe", "\u4f70", "\u4edf"};
    private static final String CN_FULL = "\u6574";
    private static final String CN_NEGATIVE = "\u8d1f";
    private static final int MONEY_PRECISION = 2;
    private static final String CN_ZEOR_FULL = "\u96f6\u5143\u6574";
    public static String MONEY_FORMAT = "###,##0.00";
    private static ThreadLocal<DecimalFormat> MONEY_FORMAT_THREAD_LOCAL = ThreadLocal.withInitial(() -> new DecimalFormat(MONEY_FORMAT));

    private NumberUtils() {
    }

    public static String format(BigDecimal num) {
        double val = 0.0;
        if (null != num) {
            val = num.setScale(2, RoundingMode.HALF_UP).doubleValue();
        }
        return MONEY_FORMAT_THREAD_LOCAL.get().format(val);
    }

    public static String format(double num) {
        return MONEY_FORMAT_THREAD_LOCAL.get().format(num);
    }

    public static String format(long num) {
        return MONEY_FORMAT_THREAD_LOCAL.get().format(num);
    }

    public static String format(int num) {
        return MONEY_FORMAT_THREAD_LOCAL.get().format(num);
    }

    public static int parseToInt(String source) {
        try {
            return MONEY_FORMAT_THREAD_LOCAL.get().parse(source).intValue();
        }
        catch (ParseException e) {
            LOGGER.debug(e.getMessage());
            return 0;
        }
    }

    public static float parseToFloat(String source) {
        try {
            return MONEY_FORMAT_THREAD_LOCAL.get().parse(source).floatValue();
        }
        catch (ParseException e) {
            LOGGER.debug(e.getMessage());
            return 0.0f;
        }
    }

    public static double parseToDouble(String source) {
        try {
            return MONEY_FORMAT_THREAD_LOCAL.get().parse(source).doubleValue();
        }
        catch (ParseException e) {
            LOGGER.debug(e.getMessage());
            return 0.0;
        }
    }

    public static long parseToLong(String source) {
        try {
            return MONEY_FORMAT_THREAD_LOCAL.get().parse(source).longValue();
        }
        catch (ParseException e) {
            LOGGER.debug(e.getMessage());
            return 0L;
        }
    }

    public static BigDecimal parseToDecimal(String source) {
        double val = NumberUtils.parseToDouble(source);
        return new BigDecimal(val);
    }

    public static String parseToCNMonetaryUnit(BigDecimal num) {
        if (null == num) {
            num = new BigDecimal(0);
        }
        return NumberUtils.number2CNMonetaryUnit(num);
    }

    private static String number2CNMonetaryUnit(BigDecimal numberOfMoney) {
        StringBuilder sb = new StringBuilder();
        int signum = numberOfMoney.signum();
        if (signum == 0) {
            return CN_ZEOR_FULL;
        }
        long number = numberOfMoney.movePointRight(2).setScale(0, 4).abs().longValue();
        long scale = number % 100L;
        int numUnit = 0;
        int numIndex = 0;
        boolean getZero = false;
        if (scale <= 0L) {
            numIndex = 2;
            number /= 100L;
            getZero = true;
        }
        if (scale > 0L && scale % 10L <= 0L) {
            numIndex = 1;
            number /= 10L;
            getZero = true;
        }
        int zeroSize = 0;
        while (number > 0L) {
            numUnit = (int)(number % 10L);
            if (numUnit > 0) {
                if (numIndex == 9 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[6]);
                }
                if (numIndex == 13 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[10]);
                }
                sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                getZero = false;
                zeroSize = 0;
            } else {
                ++zeroSize;
                if (!getZero) {
                    sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                }
                if (numIndex == 2) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                } else if ((numIndex - 2) % 4 == 0 && number % 1000L > 0L) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                }
                getZero = true;
            }
            number /= 10L;
            ++numIndex;
        }
        if (signum == -1) {
            sb.insert(0, CN_NEGATIVE);
        }
        if (scale <= 0L) {
            sb.append(CN_FULL);
        }
        return sb.toString();
    }

    public static BigDecimal getBigDecimal(Object value) {
        BigDecimal ret = null;
        if (value != null) {
            if (value instanceof BigDecimal) {
                ret = (BigDecimal)value;
            } else if (value instanceof String) {
                ret = new BigDecimal((String)value);
            } else if (value instanceof BigInteger) {
                ret = new BigDecimal((BigInteger)value);
            } else if (value instanceof Number) {
                ret = new BigDecimal(((Number)value).doubleValue());
            } else {
                throw new ClassCastException("Not possible to coerce [" + value + "] from class " + value.getClass() + " into a BigDecimal.");
            }
        }
        return ret;
    }

    public static List<String> getIntervals(int intervals) {
        ArrayList pastDaysList = Lists.newArrayList();
        for (int i = 0; i < intervals; ++i) {
            pastDaysList.add(NumberUtils.getPastDate(i));
        }
        return pastDaysList;
    }

    private static String getPastDate(int past) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(6, calendar.get(6) - past);
        Date today = calendar.getTime();
        return DateUtils.PATTERN_MONTH_DAY_FORMAT.get().format(today);
    }
}

