/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.tools;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static String getFileExtension(File file) {
        String fileExtension = "";
        if (null != file && file.exists() && !file.isDirectory()) {
            fileExtension = FileUtils.getFilextension(file.getName());
        }
        return fileExtension;
    }

    public static String getFilextension(String fileName) {
        String fileExtension = "";
        if (StringUtils.isNotBlank((String)fileName)) {
            fileExtension = StringUtils.substring((String)fileName, (int)(fileName.lastIndexOf(".") + 1), (int)fileName.length());
        }
        return fileExtension;
    }

    public static String getClassRootPath() {
        String absolutePath = FileUtils.class.getClassLoader().getResource("").getPath();
        return FileUtils.decode(absolutePath);
    }

    public static String getProjectRootPath() {
        File classRootPath = new File(FileUtils.getClassRootPath());
        return classRootPath.getParentFile().getParentFile().getAbsolutePath();
    }

    public static String getClassPath(Class<?> clasz) {
        String classAbsolutePath = clasz.getResource("").getPath();
        return FileUtils.decode(classAbsolutePath);
    }

    public static String decode(String filePath) {
        try {
            filePath = URLDecoder.decode(filePath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u5bf9{}\u8fdb\u884c\u89e3\u7801\u5931\u8d25", (Object)e, (Object)filePath);
        }
        return filePath;
    }

    public static boolean checkAndCreateFolder(String path) {
        File file = new File(path);
        return FileUtils.checkAndCreateFolder(file);
    }

    public static boolean checkAndCreateFolder(File file) {
        boolean flag = true;
        if (!file.exists()) {
            flag = file.mkdirs();
        }
        return flag;
    }

    public static boolean checkAndCreateFile(String path) throws IOException {
        File file = new File(path);
        return FileUtils.checkAndCreateFile(file);
    }

    public static boolean checkAndCreateFile(File file) throws IOException {
        boolean flag = true;
        if (!file.exists()) {
            File folder = file.getParentFile();
            if (!folder.exists()) {
                flag = folder.mkdirs();
            }
            if (flag) {
                flag = file.createNewFile();
            }
        }
        return flag;
    }

    public static String getMD5(File file) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(org.apache.commons.io.FileUtils.readFileToByteArray((File)file));
            BigInteger bigInt = new BigInteger(1, md5.digest());
            return bigInt.toString(16);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String getFileName(String path) {
        if (null == path) {
            return null;
        }
        if ((path = path.replaceAll("\\\\", "/")).indexOf("/") == 0) {
            return path;
        }
        return path.substring(path.lastIndexOf("/") + 1);
    }
}

