package com.bxm.newidea.component.tools;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 反射相关的工具类
 * @author liujia 2018/4/11 19:45
 */
public class ReflectionUtils extends org.springframework.util.ReflectionUtils {

    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionUtils.class);

    private static final Map<Class<?>, Class<?>> CLASS_MAP = new HashMap<Class<?>, Class<?>>();

    /**
     *初始化基础类Map
     * @param
     * @return
     */
    static {
        CLASS_MAP.put(Integer.class, int.class);
        CLASS_MAP.put(Character.class, char.class);
        CLASS_MAP.put(Long.class, long.class);
        CLASS_MAP.put(Float.class, float.class);
        CLASS_MAP.put(Double.class, double.class);
        CLASS_MAP.put(Byte.class, byte.class);
        CLASS_MAP.put(Short.class, short.class);
        CLASS_MAP.put(Boolean.class, boolean.class);
    }

    private ReflectionUtils() {
    }

    /**
     * 判断对象是否为数字
     * @param clasz 待判断对象
     * @return true表示obj是数值
     */
    public static boolean isNumeric(Class<?> clasz) {
        return int.class.isAssignableFrom(clasz) ||
                Integer.class.isAssignableFrom(clasz) ||
                float.class.isAssignableFrom(clasz) ||
                double.class.isAssignableFrom(clasz) ||
                Double.class.isAssignableFrom(clasz) ||
                Float.class.isAssignableFrom(clasz) ||
                long.class.isAssignableFrom(clasz) ||
                Long.class.isAssignableFrom(clasz) ||
                short.class.isAssignableFrom(clasz) ||
                Short.class.isAssignableFrom(clasz) ||
                byte.class.isAssignableFrom(clasz) ||
                Byte.class.isAssignableFrom(clasz);
    }

    /**
     * 判断对象是否为数字
     * @param obj 待判断对象
     * @return true表示obj是数值
     */
    public static boolean isNumeric(Object obj){
        if(null == obj){
            return false;
        }

        Class clasz = obj.getClass();

        return int.class.isAssignableFrom(clasz) ||
                Integer.class.isAssignableFrom(clasz) ||
                float.class.isAssignableFrom(clasz) ||
                Float.class.isAssignableFrom(clasz) ||
                long.class.isAssignableFrom(clasz) ||
                Long.class.isAssignableFrom(clasz) ||
                short.class.isAssignableFrom(clasz) ||
                Short.class.isAssignableFrom(clasz) ||
                byte.class.isAssignableFrom(clasz) ||
                Byte.class.isAssignableFrom(clasz);
    }

    /**
     * 判断一个类型是否为基础类型
     * @param clasz class信息
     * @return true表示为基础类型
     */
    public static boolean isPrimitiveType(Class<?> clasz) {
        return isNumeric(clasz) ||
                char.class.isAssignableFrom(clasz) ||
                CharSequence.class.isAssignableFrom(clasz) ||
                String.class.isAssignableFrom(clasz) ||
                boolean.class.isAssignableFrom(clasz) ||
                Boolean.class.isAssignableFrom(clasz);

    }

    /**
     * 判断字段是否是简单类型<br/>
     * 此处的简单类型包含Java中的基础类型和封装类，还包含java.util.Date等基础数据类型
     * @param field 字段信息
     * @return true表示字段是简单数据类型
     */
    public static boolean isSimpleType(Field field) {
        boolean result = false;

        Class<?> fieldClasz = field.getType();
        if (fieldClasz.isPrimitive()) {
            result = true;
        } else if (isWarper(fieldClasz)) {
            result = true;
        } else {
            if (String.class.isAssignableFrom(fieldClasz) || Date.class.isAssignableFrom(fieldClasz) || java.util.Date.class.isAssignableFrom(fieldClasz)) {
                result = true;
            }
        }

        return result;
    }

    /**
     * 判断字段类型是否是原始类型的封装类
     * @param clasz 字段信息
     * @return true表示字段类型是原始类型封装类
     */
    public static boolean isWarper(Class<?> clasz) {
        if (clasz == null) {
            return false;
        }
        try {
            Field[] fields = clasz.getDeclaredFields();
            for (Field field : fields) {
                if ("TYPE".equals(field.getName())) {
                    return ((Class<?>) field.get(null)).isPrimitive();
                }
            }
        } catch (IllegalArgumentException | IllegalAccessException e) {
            LOGGER.error(e.getMessage(), e);
        }
        return false;
    }

    /**
     * 根据类加载器，判断类是否是Java基础的类型
     * @param clasz 类信息
     * @return true表示是Java内置对象
     */
    public static boolean isJavaClass(Class<?> clasz) {
        return clasz != null && clasz.getClassLoader() == null;
    }

    /**
     * 根据类对象获取该对象基础类型 非基础类型返回对象封装类
     * @param wrapperClassObject
     * @return
     */
    @SuppressWarnings("rawtypes")
    public static Class wrapperClassToBaseClass(Object wrapperClassObject) {
        Class wrapperClass = wrapperClassObject.getClass();

        return wrapperClassToBaseClass(wrapperClass);
    }

    /**
     * 获取封装类型对应的原始类型，如果参数不是基础类型的封装类，则返回参数
     * @param wrapperClass
     * @return
     */
    @SuppressWarnings("rawtypes")
    public static Class wrapperClassToBaseClass(Class wrapperClass) {
        Class baseClass = CLASS_MAP.get(wrapperClass);

        if (null == baseClass) {
            baseClass = wrapperClass;
        }
        return baseClass;
    }

    /**
     * 获取get方法对应的字段名称
     * @param methodName 方法名称
     * @return 对应的字段名称, 如果不是get方法则返回null
     */
    public static String getFieldName(String methodName) {
        String fieldName;
        if (StringUtils.startsWith(methodName, "get")) {
            fieldName = StringUtils.replaceFirst(methodName, "get", "");
        } else if (StringUtils.startsWith(methodName, "is")) {
            fieldName = StringUtils.replaceFirst(methodName, "is", "");
        } else {
            return null;
        }

        return StringUtils.lowerCaseFirstChar(fieldName);
    }

}
