package com.bxm.newidea.component.enums;

/**
 * 帖子状态枚举类 帖子状态(1:正常显示 2:审核中 3:审核拒绝 4:用户删除 5:仅楼主可见 6:本地圈屏蔽 7:运营删除)
 */
public enum ForumPostStatusEnum {
    NORMAL_DISPLAY(1,"正常显示"),
    PENDING_REVIEW(2,"审核中"),
    REVIEW_REJECTED(3,"审核拒绝"),
    USER_DELETE(4,"用户删除"),
    VISIBLE_ONLY_TO_MYSELF(5,"仅楼主可见"),
    LOCAL_CIRCLE_SHIELD(6,"本地圈屏蔽"),
    OPERATION_DELETE(7,"运营删除"),
    ;
    ForumPostStatusEnum( int status,String desc){
        this.status = status;
        this.desc = desc;
    }

    private   int status;

    private String desc;

    public int getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }
}
