package com.bxm.newidea.component.tools;

import com.bxm.newidea.component.vo.Placeholder;
import lombok.SneakyThrows;
import lombok.experimental.UtilityClass;

import java.lang.reflect.Field;
import java.util.Objects;

@UtilityClass
public class PlaceholderUtils {

    /**
     * 用途：占位符替换，
     * 继承 PlaceholderObject 类，属性作为占位符名称，值作为需要替换后的值
     * 属性只支持基础类型或者String类型
     * 占位符只支持格式{xxxx}
     * @param origin
     * @param placeholder
     * @return
     */
    @SneakyThrows
    public static String replacePlaceholder(String origin, Placeholder placeholder) {
        Class<?> clz = placeholder.getClass();
        Field[] fields = clz.getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            //如果是基本类型或者是String类型
            if (field.getType().isPrimitive() || field.getType() == String.class) {
                String name = field.getName();
                Object value = field.get(placeholder);
                if (Objects.isNull(value)) {
                    continue;
                }
                String target = "{" + name + "}";

                String replacement = value.toString();

                origin = origin.replace(target, replacement);
            }
        }
        return origin;
    }
}
