package com.bxm.newidea.component.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Objects;

/**
 * 兼容万事通历史方案
 */
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "api传递的通用基础参数")
@Data
@Deprecated
public class BasicParam extends BaseBean {
    @ApiModelProperty(
            value = "通用参数：平台类型,1:ANDROID,2:IOS,3:WEB,4:大转盘,5:小程序",
            required = true
    )
    private int platform;

    @ApiModelProperty(
            value = "通用参数：当前APP的上线版本",
            required = true
    )
    private String curVer;

    @ApiModelProperty(
            value = "通用参数：请求渠道来源",
            required = true
    )
    private String chnl;

    @ApiModelProperty(
            value = "通用参数：设备编号",
            required = true
    )
    private String devcId;

    @ApiModelProperty(
            value = "通用参数：客户端时间",
            required = true
    )
    private Long cliTime;

    @ApiModelProperty(value = "通用参数：当前服务端API的版本")
    private String version;

    @ApiModelProperty(
            value = "通用参数：请求参数的来源系统，选取值参见：com.bxm.newidea.component.enums.AppNameEnum",
            hidden = true
    )
    private String srcApp;

    /**
     * merge basic 参数
     * @param param
     */
    public void merge(BasicParam param) {
        if (Objects.nonNull(param)) {
            this.platform = param.getPlatform();
            this.curVer = param.getCurVer();
            this.chnl = param.getChnl();
            this.devcId = param.getDevcId();
            this.cliTime = param.getCliTime();
            this.version = param.getVersion();
            this.srcApp = param.getSrcApp();
        }
    }
}