package com.bxm.newidea.component.enums;

/**
 * 文件后缀与content type的映射关系
 */
public enum FileTypeEnum {

    /**
     * page
     **/
    PAGE("page", "text/html"),
    /**
     * layout
     **/
    LAYOUT("layout", "text/html"),
    /**
     * js
     **/
    JS("js", "text/javascript"),
    /**
     * css
     **/
    CSS("css", "text/css"),
    /**
     * jsp
     **/
    JSP("jsp", "text/html"),
    /**
     * evy
     **/
    EVY("evy", "application/envoy"),
    /**
     * fif
     **/
    FIF("fif", "application/fractals"),
    /**
     * spl
     **/
    SPL("spl", "application/futuresplash"),
    /**
     * hta
     **/
    HTA("hta", "application/hta"),
    /**
     * acx
     **/
    ACX("acx", "application/internet-property-stream"),
    /**
     * hqx
     **/
    HQX("hqx", "application/mac-binhex40"),
    /**
     * doc
     **/
    DOC("doc", "application/msword"),
    /**
     * woff
     **/
    WOFF("woff", "application/x-font-woff"),
    /**
     * ttf
     **/
    TTF("ttf", "application/x-font-ttf"),
    /**
     * dot
     **/
    DOT("dot", "application/msword"),
    /**
     * bin
     **/
    BIN("bin", "application/octet-stream"),
    /**
     * dms
     **/
    DMS("dms", "application/octet-stream"),
    /**
     * exe
     **/
    EXE("exe", "application/octet-stream"),
    /**
     * lha
     **/
    LHA("lha", "application/octet-stream"),
    /**
     * lzh
     **/
    LZH("lzh", "application/octet-stream"),
    /**
     * oda
     **/
    ODA("oda", "application/oda"),
    /**
     * axs
     **/
    AXS("axs", "application/olescript"),
    /**
     * pdf
     **/
    PDF("pdf", "application/pdf"),
    /**
     * prf
     **/
    PRF("prf", "application/pics-rules"),
    /**
     * p10
     **/
    P10("p10", "application/pkcs10"),
    /**
     * crl
     **/
    CRL("crl", "application/pkix-crl"),
    /**
     * ai
     **/
    AI("ai", "application/postscript"),
    /**
     * eps
     **/
    EPS("eps", "application/postscript"),
    /**
     * ps
     **/
    PS("ps", "application/postscript"),
    /**
     * rtf
     **/
    RTF("rtf", "application/rtf"),
    /**
     * setpay
     **/
    SETPAY("setpay", "application/set-payment-initiation"),
    /**
     * setreg
     **/
    SETREG("setreg", "application/set-registration-initiation"),
    /**
     * xla
     **/
    XLA("xla", "application/vnd.ms-excel"),
    /**
     * xlc
     **/
    XLC("xlc", "application/vnd.ms-excel"),
    /**
     * xlm
     **/
    XLM("xlm", "application/vnd.ms-excel"),
    /**
     * xls
     **/
    XLS("xls", "application/vnd.ms-excel"),
    /**
     * xlt
     **/
    XLT("xlt", "application/vnd.ms-excel"),
    /**
     * xlw
     **/
    XLW("xlw", "application/vnd.ms-excel"),
    /**
     * msg
     **/
    MSG("msg", "application/vnd.ms-outlook"),
    /**
     * sst
     **/
    SST("sst", "application/vnd.ms-pkicertstore"),
    /**
     * cat
     **/
    CAT("cat", "application/vnd.ms-pkiseccat"),
    /**
     * stl
     **/
    STL("stl", "application/vnd.ms-pkistl"),
    /**
     * pot
     **/
    POT("pot", "application/vnd.ms-powerpoint"),
    /**
     * pps
     **/
    PPS("pps", "application/vnd.ms-powerpoint"),
    /**
     * ppt
     **/
    PPT("ppt", "application/vnd.ms-powerpoint"),
    /**
     * mpp
     **/
    MPP("mpp", "application/vnd.ms-project"),
    /**
     * wcm
     **/
    WCM("wcm", "application/vnd.ms-works"),
    /**
     * wdb
     **/
    WDB("wdb", "application/vnd.ms-works"),
    /**
     * wks
     **/
    WKS("wks", "application/vnd.ms-works"),
    /**
     * wps
     **/
    WPS("wps", "application/vnd.ms-works"),
    /**
     * hlp
     **/
    HLP("hlp", "application/winhlp"),
    /**
     * bcpio
     **/
    BCPIO("bcpio", "application/x-bcpio"),
    /**
     * z
     **/
    Z("z", "application/x-compress"),
    /**
     * tgz
     **/
    TGZ("tgz", "application/x-compressed"),
    /**
     * cpio
     **/
    CPIO("cpio", "application/x-cpio"),
    /**
     * csh
     **/
    CSH("csh", "application/x-csh"),
    /**
     * dcr
     **/
    DCR("dcr", "application/x-director"),
    /**
     * dir
     **/
    DIR("dir", "application/x-director"),
    /**
     * dxr
     **/
    DXR("dxr", "application/x-director"),
    /**
     * dvi
     **/
    DVI("dvi", "application/x-dvi"),
    /**
     * gtar
     **/
    GTAR("gtar", "application/x-gtar"),
    /**
     * gz
     **/
    GZ("gz", "application/x-gzip"),
    /**
     * hdf
     **/
    HDF("hdf", "application/x-hdf"),
    /**
     * ins
     **/
    INS("ins", "application/x-internet-signup"),
    /**
     * isp
     **/
    ISP("isp", "application/x-internet-signup"),
    /**
     * iii
     **/
    III("iii", "application/x-iphone"),
    /**
     * latex
     **/
    LATEX("latex", "application/x-latex"),
    /**
     * mdb
     **/
    MDB("mdb", "application/x-msaccess"),
    /**
     * crd
     **/
    CRD("crd", "application/x-mscardfile"),
    /**
     * clp
     **/
    CLP("clp", "application/x-msclip"),
    /**
     * dll
     **/
    DLL("dll", "application/x-msdownload"),
    /**
     * m13
     **/
    M13("m13", "application/x-msmediaview"),
    /**
     * m14
     **/
    M14("m14", "application/x-msmediaview"),
    /**
     * mvb
     **/
    MVB("mvb", "application/x-msmediaview"),
    /**
     * wmf
     **/
    WMF("wmf", "application/x-msmetafile"),
    /**
     * mny
     **/
    MNY("mny", "application/x-msmoney"),
    /**
     * pub
     **/
    PUB("pub", "application/x-mspublisher"),
    /**
     * scd
     **/
    SCD("scd", "application/x-msschedule"),
    /**
     * trm
     **/
    TRM("trm", "application/x-msterminal"),
    /**
     * wri
     **/
    WRI("wri", "application/x-mswrite"),
    /**
     * cdf
     **/
    CDF("cdf", "application/x-netcdf"),
    /**
     * nc
     **/
    NC("nc", "application/x-netcdf"),
    /**
     * pma
     **/
    PMA("pma", "application/x-perfmon"),
    /**
     * pmc
     **/
    PMC("pmc", "application/x-perfmon"),
    /**
     * pml
     **/
    PML("pml", "application/x-perfmon"),
    /**
     * pmr
     **/
    PMR("pmr", "application/x-perfmon"),
    /**
     * pmw
     **/
    PMW("pmw", "application/x-perfmon"),
    /**
     * p12
     **/
    P12("p12", "application/x-pkcs12"),
    /**
     * pfx
     **/
    PFX("pfx", "application/x-pkcs12"),
    /**
     * p7b
     **/
    P7B("p7b", "application/x-pkcs7-certificates"),
    /**
     * spc
     **/
    SPC("spc", "application/x-pkcs7-certificates"),
    /**
     * p7r
     **/
    P7R("p7r", "application/x-pkcs7-certreqresp"),
    /**
     * p7c
     **/
    P7C("p7c", "application/x-pkcs7-mime"),
    /**
     * p7m
     **/
    P7M("p7m", "application/x-pkcs7-mime"),
    /**
     * p7s
     **/
    P7S("p7s", "application/x-pkcs7-signature"),
    /**
     * sh
     **/
    SH("sh", "application/x-sh"),
    /**
     * shar
     **/
    SHAR("shar", "application/x-shar"),
    /**
     * swf
     **/
    SWF("swf", "application/x-shockwave-flash"),
    /**
     * sit
     **/
    SIT("sit", "application/x-stuffit"),
    /**
     * sv4cpio
     **/
    SV4CPIO("sv4cpio", "application/x-sv4cpio"),
    /**
     * sv4crc
     **/
    SV4CRC("sv4crc", "application/x-sv4crc"),
    /**
     * tar
     **/
    TAR("tar", "application/x-tar"),
    /**
     * tcl
     **/
    TCL("tcl", "application/x-tcl"),
    /**
     * tex
     **/
    TEX("tex", "application/x-tex"),
    /**
     * texi
     **/
    TEXI("texi", "application/x-texinfo"),
    /**
     * texinfo
     **/
    TEXINFO("texinfo", "application/x-texinfo"),
    /**
     * roff
     **/
    ROFF("roff", "application/x-troff"),
    /**
     * t
     **/
    T("t", "application/x-troff"),
    /**
     * tr
     **/
    TR("tr", "application/x-troff"),
    /**
     * man
     **/
    MAN("man", "application/x-troff-man"),
    /**
     * me
     **/
    ME("me", "application/x-troff-me"),
    /**
     * ms
     **/
    MS("ms", "application/x-troff-ms"),
    /**
     * ustar
     **/
    USTAR("ustar", "application/x-ustar"),
    /**
     * src
     **/
    SRC("src", "application/x-wais-source"),
    /**
     * cer
     **/
    CER("cer", "application/x-x509-ca-cert"),
    /**
     * crt
     **/
    CRT("crt", "application/x-x509-ca-cert"),
    /**
     * der
     **/
    DER("der", "application/x-x509-ca-cert"),
    /**
     * pko
     **/
    PKO("pko", "application/ynd.ms-pkipko"),
    /**
     * zip
     **/
    ZIP("zip", "application/zip"),
    /**
     * au
     **/
    AU("au", "audio/basic"),
    /**
     * snd
     **/
    SND("snd", "audio/basic"),
    /**
     * mid
     **/
    MID("mid", "audio/mid"),
    /**
     * rmi
     **/
    RMI("rmi", "audio/mid"),
    /**
     * mp3
     **/
    MP3("mp3", "audio/mpeg"),
    /**
     * aif
     **/
    AIF("aif", "audio/x-aiff"),
    /**
     * aifc
     **/
    AIFC("aifc", "audio/x-aiff"),
    /**
     * aiff
     **/
    AIFF("aiff", "audio/x-aiff"),
    /**
     * m3u
     **/
    M3U("m3u", "audio/x-mpegurl"),
    /**
     * ra
     **/
    RA("ra", "audio/x-pn-realaudio"),
    /**
     * ram
     **/
    RAM("ram", "audio/x-pn-realaudio"),
    /**
     * wav
     **/
    WAV("wav", "audio/x-wav"),
    /**
     * bmp
     **/
    BMP("bmp", "image/bmp"),
    /**
     * cod
     **/
    COD("cod", "image/cis-cod"),
    /**
     * gif
     **/
    GIF("gif", "image/gif"),
    /**
     * ief
     **/
    IEF("ief", "image/ief"),
    /**
     * jpe
     **/
    JPE("jpe", "image/jpeg"),
    /**
     * jpeg
     **/
    JPEG("jpeg", "image/jpeg"),
    /**
     * jpg
     **/
    JPG("jpg", "image/jpeg"),
    /**
     * png
     **/
    PNG("png", "image/png"),
    /**
     * jfif
     **/
    JFIF("jfif", "image/pipeg"),
    /**
     * svg
     **/
    SVG("svg", "image/svg+xml"),
    /**
     * tif
     **/
    TIF("tif", "image/tiff"),
    /**
     * tiff
     **/
    TIFF("tiff", "image/tiff"),
    /**
     * ras
     **/
    RAS("ras", "image/x-cmu-raster"),
    /**
     * cmx
     **/
    CMX("cmx", "image/x-cmx"),
    /**
     * ico
     **/
    ICO("ico", "image/x-icon"),
    /**
     * pnm
     **/
    PNM("pnm", "image/x-portable-anymap"),
    /**
     * pbm
     **/
    PBM("pbm", "image/x-portable-bitmap"),
    /**
     * pgm
     **/
    PGM("pgm", "image/x-portable-graymap"),
    /**
     * ppm
     **/
    PPM("ppm", "image/x-portable-pixmap"),
    /**
     * rgb
     **/
    RGB("rgb", "image/x-rgb"),
    /**
     * xbm
     **/
    XBM("xbm", "image/x-xbitmap"),
    /**
     * xpm
     **/
    XPM("xpm", "image/x-xpixmap"),
    /**
     * xwd
     **/
    XWD("xwd", "image/x-xwindowdump"),
    /**
     * mht
     **/
    MHT("mht", "message/rfc822"),
    /**
     * mhtml
     **/
    MHTML("mhtml", "message/rfc822"),
    /**
     * nws
     **/
    NWS("nws", "message/rfc822"),
    /**
     * htm
     **/
    HTM("htm", "text/html"),
    /**
     * html
     **/
    HTML("html", "text/html"),
    /**
     * stm
     **/
    STM("stm", "text/html"),
    /**
     * uls
     **/
    ULS("uls", "text/iuls"),
    /**
     * bas
     **/
    BAS("bas", "text/plain"),
    /**
     * c
     **/
    C("c", "text/plain"),
    /**
     * h
     **/
    H("h", "text/plain"),
    /**
     * txt
     **/
    TXT("txt", "text/plain"),
    /**
     * rtx
     **/
    RTX("rtx", "text/richtext"),
    /**
     * sct
     **/
    SCT("sct", "text/scriptlet"),
    /**
     * tsv
     **/
    TSV("tsv", "text/tab-separated-values"),
    /**
     * htt
     **/
    HTT("htt", "text/webviewhtml"),
    /**
     * htc
     **/
    HTC("htc", "text/x-component"),
    /**
     * etx
     **/
    ETX("etx", "text/x-setext"),
    /**
     * vcf
     **/
    VCF("vcf", "text/x-vcard"),
    /**
     * mp2
     **/
    MP2("mp2", "video/mpeg"),
    /**
     * mp4
     **/
    MP4("mp4", "video/mpeg4"),
    /**
     * mpa
     **/
    MPA("mpa", "video/mpeg"),
    /**
     * mpe
     **/
    MPE("mpe", "video/mpeg"),
    /**
     * mpeg
     **/
    MPEG("mpeg", "video/mpeg"),
    /**
     * mpg
     **/
    MPG("mpg", "video/mpeg"),
    /**
     * mpv2
     **/
    MPV2("mpv2", "video/mpeg"),
    /**
     * mov
     **/
    MOV("mov", "video/quicktime"),
    /**
     * qt
     **/
    QT("qt", "video/quicktime"),
    /**
     * lsf
     **/
    LSF("lsf", "video/x-la-asf"),
    /**
     * lsx
     **/
    LSX("lsx", "video/x-la-asf"),
    /**
     * asf
     **/
    ASF("asf", "video/x-ms-asf"),
    /**
     * asr
     **/
    ASR("asr", "video/x-ms-asf"),
    /**
     * asx
     **/
    ASX("asx", "video/x-ms-asf"),
    /**
     * avi
     **/
    AVI("avi", "video/x-msvideo"),
    /**
     * flv
     **/
    FLV("flv", "video/x-flv"),
    /**
     * movie
     **/
    MOVIE("movie", "video/x-sgi-movie"),
    /**
     * flr
     **/
    FLR("flr", "x-world/x-vrml"),
    /**
     * vrml
     **/
    VRML("vrml", "x-world/x-vrml"),
    /**
     * wrl
     **/
    WRL("wrl", "x-world/x-vrml"),
    /**
     * wrz
     **/
    WRZ("wrz", "x-world/x-vrml"),
    /**
     * xaf
     **/
    XAF("xaf", "x-world/x-vrml"),
    /**
     * xof
     **/
    XOF("xof", "x-world/x-vrml");

    /**
     * 文件后缀名
     **/
    private final String extName;

    /**
     * 文件内容类型
     **/
    private final String contentType;

    FileTypeEnum(String extName, String contentType) {
        this.extName = extName;
        this.contentType = contentType;
    }

    //普通方法
    public static String getContentType(String extName) {
        FileTypeEnum[] arr = FileTypeEnum.values();
        for (FileTypeEnum c : arr) {
            if (c.getExtName().equals(extName)) {
                return c.contentType;
            }
        }
        return null;
    }

    // 普通方法
    public static FileTypeEnum get(String extName) {
        FileTypeEnum[] arr = FileTypeEnum.values();
        for (FileTypeEnum c : arr) {
            if (c.getExtName().equals(extName)) {
                return c;
            }
        }
        return null;
    }

    public String getExtName() {
        return extName;
    }

    public String getContentType() {
        return contentType;
    }
}
