/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.tools;

import com.bxm.newidea.component.tools.RandomUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;

public class CaptchaUtil {
    private static final String VERIFY_CODES = "23456789abcdefghigklmnpqrstuvwxyz";
    private static Random random = new Random();

    public static String getRundomStr(int n) {
        StringBuilder sb = new StringBuilder();
        String[] strs = VERIFY_CODES.split("");
        for (int i = 0; i < n; ++i) {
            int a = random.nextInt(strs.length);
            if (a < 24) {
                int b = random.nextInt(100);
                if (b % 2 == 0) {
                    String temp = strs[a].toUpperCase();
                    sb.append(temp);
                    continue;
                }
                sb.append(strs[a]);
                continue;
            }
            sb.append(strs[a]);
        }
        return sb.toString();
    }

    public static void createImage(int width, int height, String str, OutputStream out) throws IOException {
        int i;
        int verifySize = str.length();
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g2 = image.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color[] colors = new Color[5];
        Color[] colorSpaces = new Color[]{Color.WHITE, Color.CYAN, Color.GRAY, Color.LIGHT_GRAY, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.YELLOW};
        float[] fractions = new float[colors.length];
        for (i = 0; i < colors.length; ++i) {
            colors[i] = colorSpaces[RandomUtils.nextInt((int)0, (int)colorSpaces.length)];
            fractions[i] = RandomUtils.nextFloat();
        }
        g2.setColor(new Color(255, 255, 255));
        g2.fillRect(0, 0, width, height);
        for (i = 0; i < 4; ++i) {
            g2.setColor(CaptchaUtil.getRundomRgb(40, 180));
            g2.drawLine(CaptchaUtil.randomNum(0, width), CaptchaUtil.randomNum(0, height), CaptchaUtil.randomNum(0, width), CaptchaUtil.randomNum(0, height));
        }
        int fontSize = height - 2;
        Font font = new Font("Algerian", 2, fontSize);
        char[] chars = str.toCharArray();
        for (int i2 = 0; i2 < verifySize; ++i2) {
            g2.setColor(CaptchaUtil.getRundomRgb(40, 180));
            g2.setFont(font);
            AffineTransform affine = new AffineTransform();
            affine.setToRotation(0.7853981633974483 * RandomUtils.nextDouble() * (double)(RandomUtils.nextBoolean() ? 1 : -1), (double)width / (double)verifySize * (double)i2 + (double)fontSize / 2.0, (double)height / 2.0);
            g2.setTransform(affine);
            g2.drawChars(chars, i2, 1, (width - 10) / verifySize * i2 + 5, height / 2 + fontSize / 2 - 10);
        }
        g2.dispose();
        ImageIO.write((RenderedImage)image, "png", out);
    }

    private static Color getRundomRgb(int pr, int pg) {
        if (pr > 255) {
            pr = 255;
        }
        if (pg > 255) {
            pg = 255;
        }
        int r = pr + random.nextInt(pg - pr);
        int g = pr + random.nextInt(pg - pr);
        int b = pr + random.nextInt(pg - pr);
        return new Color(r, g, b);
    }

    private static int randomNum(int min, int max) {
        return (int)Math.floor(Math.random() * (double)(max - min) + (double)min);
    }
}

