package com.bxm.newidea.cloud.fegin;

import com.bxm.newidea.cloud.constant.EnvConstant;
import com.bxm.newidea.cloud.ribbon.RibbonFilterContextHolder;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FeignRequestInterceptor implements RequestInterceptor {

    private static final Logger LOGGER = LoggerFactory.getLogger(FeignRequestInterceptor.class);

    @Override
    public void apply(RequestTemplate template) {
        String env = RibbonFilterContextHolder.getCurrentContext().get(EnvConstant.ENV_HEADER_KEY);
        if (null != env) {
            template.header(EnvConstant.ENV_HEADER_KEY, EnvConstant.PRE_ENV_VALUE);
        }

        LOGGER.debug("request template,request url:" + template.url() + ",request env:" + env);
    }
}
