package com.bxm.newidea.component.util;

import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.config.PointInfoProperties;
import com.bxm.newidea.component.model.param.PointParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/6/8 2:15 下午
 */
@Service
@Slf4j
public class PointReportUtils {

    @Autowired
    private PointInfoProperties pointInfoProperties;

    private static PointInfoProperties realPointInfoProperties;

    @PostConstruct
    public void init() {
        PointReportUtils.realPointInfoProperties = this.pointInfoProperties;
    }


    public static void report(PointParam param) {
        log.debug("report point:{}", param);

        Map<String, String> data = param.getMap();
        Map<String, String> headerMap = new HashMap<>();

        headerMap.put("Content-Type", "application/json");
        try {
            data.computeIfAbsent("v", k -> realPointInfoProperties.getReportPointVersion());
            OkHttpUtils.postJsonBody(realPointInfoProperties.getReportPointUrl(), JSON.toJSONString(data), headerMap);
        } catch (Exception e) {
            log.error("埋点上报失败，埋点内容：[{}]", JSON.toJSONString(data));
            log.error(e.getMessage(), e);
        }
    }
}