/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.util;

import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.config.PointInfoProperties;
import com.bxm.newidea.component.model.param.PointParam;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PointReportUtils {
    private static final Logger log = LoggerFactory.getLogger(PointReportUtils.class);
    @Autowired
    private PointInfoProperties pointInfoProperties;
    private static PointInfoProperties realPointInfoProperties;

    @PostConstruct
    public void init() {
        realPointInfoProperties = this.pointInfoProperties;
    }

    public static void report(PointParam param) {
        log.debug("report point:{}", (Object)param);
        Map<String, String> data = param.getMap();
        try {
            data.computeIfAbsent("v", k -> realPointInfoProperties.getReportPointVersion());
            OkHttpUtils.getWithDefaultHeader((String)realPointInfoProperties.getReportPointUrl(), data);
        }
        catch (Exception e) {
            log.error("\u57cb\u70b9\u4e0a\u62a5\u5931\u8d25\uff0c\u57cb\u70b9\u5185\u5bb9\uff1a[{}]", (Object)JSON.toJSONString(data));
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

