/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.config;

import com.bxm.newidea.component.config.ComponentPointInfoProperties;
import com.bxm.newidea.component.thread.NamedThreadFactory;
import com.bxm.newidea.component.util.ReportConsumer;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableConfigurationProperties(value={ComponentPointInfoProperties.class})
@Configuration
public class ComponentPointConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ComponentPointConfiguration.class);
    private final ComponentPointInfoProperties pointInfoProperties;
    public static final String POINT_REPORT_TASK_EXECUTOR = "POINT_REPORT_TASK_EXECUTOR";

    public ComponentPointConfiguration(ComponentPointInfoProperties pointInfoProperties) {
        this.pointInfoProperties = pointInfoProperties;
        if (pointInfoProperties.getReportPointUrl() == null && pointInfoProperties.getProjectPointUrlMap() == null) {
            log.warn("\u5f15\u5165\u4e86\u6570\u636e\u57cb\u70b9\u7ec4\u4ef6\uff0c\u4f46\u662f\u672a\u63d0\u4f9b\u6570\u636e\u57cb\u70b9\u4e0a\u4f20\u5730\u5740\uff1a[component.dot.reportPointUrl]\u6216[component.dot.projectPointUrlMap]");
        }
        if (pointInfoProperties.getProjectName() == null) {
            log.info("\u5f15\u5165\u4e86\u6570\u636e\u57cb\u70b9\u7ec4\u4ef6\uff0c\u4f46\u662f\u672a\u63d0\u4f9b\u6570\u636e\u57cb\u70b9\u5bf9\u5e94\u7684\u9879\u76ee\u540d\u79f0\uff1a[component.dot.projectName]\u3002\u5c06\u91c7\u7528spring.application.name");
        }
    }

    @Bean
    public ReportConsumer reportConsume(@Qualifier(value="POINT_REPORT_TASK_EXECUTOR") Executor executor) {
        return new ReportConsumer(this.pointInfoProperties, executor);
    }

    @Bean(value={"POINT_REPORT_TASK_EXECUTOR"})
    @ConditionalOnMissingBean(name={"POINT_REPORT_TASK_EXECUTOR"})
    public Executor threadPoolTaskExecutor() {
        ComponentPointInfoProperties.PointThreadPollConfig threadPollConfig = this.pointInfoProperties.getThreadPollConfig();
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(threadPollConfig.getCoreSize());
        executor.setMaxPoolSize(threadPollConfig.getCoreSize());
        executor.setQueueCapacity(threadPollConfig.getCapacity());
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setThreadFactory((ThreadFactory)new NamedThreadFactory("component_point_report"));
        executor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                if (!executor.isTerminated() && !executor.isTerminating()) {
                    log.error("\u57cb\u70b9\u4efb\u52a1\u8d85\u8fc7\u4e86\u7ebf\u7a0b\u6c60\u7684\u5904\u7406\u5bb9\u91cf\uff0cRunnable\uff1a{},executor:{}", (Object)r, (Object)executor);
                }
            }
        });
        return executor;
    }
}

