/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.elasticjob.config;

import com.bxm.component.elasticjob.config.ComponentElasticJobProperties;
import com.bxm.component.elasticjob.job.IShardingElasticJob;
import com.bxm.component.elasticjob.job.ISimplifyElasticJob;
import java.util.Map;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl.ScheduleJobBootstrap;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.elasticsearch.ElasticsearchDataAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@AutoConfigureAfter(value={ElasticsearchDataAutoConfiguration.class})
@ConditionalOnProperty(prefix="elasticjob.reg-center", name={"server-lists"})
@EnableConfigurationProperties(value={ComponentElasticJobProperties.class})
public class ComponentElasticJobConfiguration
implements ApplicationRunner,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ComponentElasticJobConfiguration.class);
    private ApplicationContext applicationContext;
    private CoordinatorRegistryCenter coordinatorRegistryCenter;
    private ComponentElasticJobProperties componentElasticJobProperties;

    public ComponentElasticJobConfiguration(ApplicationContext applicationContext, CoordinatorRegistryCenter coordinatorRegistryCenter, ComponentElasticJobProperties componentElasticJobProperties) {
        this.applicationContext = applicationContext;
        this.coordinatorRegistryCenter = coordinatorRegistryCenter;
        this.componentElasticJobProperties = componentElasticJobProperties;
    }

    public void run(ApplicationArguments args) throws Exception {
        if (this.componentElasticJobProperties.isEnableMock()) {
            log.info("\u914d\u7f6e\u4e86[component.elasticjob.enableMock],\u4e0d\u542f\u52a8\u5b9a\u65f6\u4efb\u52a1");
            return;
        }
        Map definedJobMap = this.applicationContext.getBeansOfType(ISimplifyElasticJob.class);
        log.info("\u626b\u63cf\u5230[{}]\u4e2a\u5b9a\u65f6\u4efb\u52a1", (Object)definedJobMap.size());
        for (ISimplifyElasticJob job : definedJobMap.values()) {
            JobConfiguration.Builder builder;
            if (null == job.cron()) {
                throw new IllegalArgumentException(job.getClass() + "\u672a\u914d\u7f6eCRON\u8868\u8fbe\u5f0f");
            }
            if (job instanceof IShardingElasticJob) {
                IShardingElasticJob shardingElasticJob = (IShardingElasticJob)job;
                builder = JobConfiguration.newBuilder((String)job.jobName(), (int)shardingElasticJob.shardingTotalCount());
                builder.shardingItemParameters(shardingElasticJob.shardingItemParameters());
            } else {
                builder = JobConfiguration.newBuilder((String)job.jobName(), (int)1);
            }
            JobConfiguration configuration = builder.cron(job.cron()).overwrite(true).failover(true).build();
            ScheduleJobBootstrap bootstrap = new ScheduleJobBootstrap(this.coordinatorRegistryCenter, (ElasticJob)job, configuration);
            log.debug("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\uff1a{}", (Object)job.jobName());
            bootstrap.schedule();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

