package com.bxm.component.elasticjob.job;

import org.apache.shardingsphere.elasticjob.simple.job.SimpleJob;

/**
 * 简化的任务接口，直接实现接口并添加到spring环境即可
 *
 * @author liujia
 * @date 6/9/21 7:29 PM
 **/
public interface ISimplifyElasticJob extends SimpleJob {

    /**
     * 设置任务执行周期
     *
     * @return 执行周期
     */
    String cron();

    /**
     * 任务名称
     *
     * @return 项目显示的名称，默认为类名
     */
    default String jobName() {
        return this.getClass().getSimpleName();
    }

    /**
     * 任务描述
     *
     * @return 任务的文本描述，必填
     */
    String description();
}
