package com.bxm.newidea.component.geo.service.impl;

import cn.hutool.http.HttpUtil;
import com.bxm.newidea.component.JSONObject;
import com.bxm.newidea.component.geo.config.GeoProperties;
import com.bxm.newidea.component.geo.dto.Coordinate;
import com.bxm.newidea.component.geo.service.GeoService;
import com.bxm.newidea.component.tools.LocationUtils;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
public class GeoServiceImpl implements GeoService {

    @Autowired
    GeoProperties geoProperties;

    @Override
    public Long getDistance(Coordinate origins, Coordinate destination) {
        if (isCoordinateEmpty(origins, destination)) {
            return null;
        }

        Double distance = LocationUtils.getDistance(
                origins.getLatitude(),
                origins.getLongitude(),
                destination.getLatitude(),
                destination.getLongitude());

        return distance.longValue();
    }

    boolean isCoordinateEmpty(Coordinate origins, Coordinate destination) {
        return
                origins.getLatitude() == null
                        || origins.getLongitude() == null
                        || destination.getLatitude() == null
                        || destination.getLongitude() == null;
    }

    @Override
    public Coordinate getCoordinate(String address) {
        Coordinate coordinate = null;

        Map<String, Object> map = Maps.newHashMap();
        map.put("key", geoProperties.getKey());
        map.put("address", address);

        String json = HttpUtil.get(geoProperties.getGeoUrl(), map);
        if (null != json) {
            JSONObject jsonObject = JSONObject.parseObject(json);
            if (jsonObject != null) {
                String status = jsonObject.getString("status");
                String count = jsonObject.getString("count");
                if ("1".equalsIgnoreCase(status) && "1".equals(count)) {
                    JSONObject geocode = jsonObject.getJSONArray("geocodes").getJSONObject(0);
                    String location = geocode.getString("location");
                    String[] coordinateArray = location.split(",");

                    coordinate = new Coordinate();
                    coordinate.setLongitude(Double.valueOf(coordinateArray[0]));
                    coordinate.setLatitude(Double.valueOf(coordinateArray[1]));
                }
            }
        }
        return coordinate;
    }
}
