package com.bxm.newidea.component.geo.service;

import com.bxm.newidea.component.geo.dto.Coordinate;

/**
 * 地理位置相关接口
 */
public interface GeoService {

    /**
     * 用途：获得单个出发点与目的地的距离
     * @param origins 出发点,包含经纬度
     * @param destination 目的地,包含经纬度
     * @return 距离（单位：米）
     */
    Long getDistance(Coordinate origins, Coordinate destination);

    /**
     * 根据地址获取经纬度信息 填写结构化地址信息:省份＋城市＋区县＋城镇＋乡村＋街道＋门牌号码
     * @param address 详细地址
     * @return LocationInfoDTO 地址包装类
     */
    Coordinate getCoordinate(String address);
}
