package com.bxm.newidea.component.geo.dto;

import lombok.Data;

/**
 * 经纬度获取地址对象
 * 结构化：省份＋城市＋区县＋城镇＋乡村＋街道＋门牌号码
 * 参考：https://lbs.amap.com/api/webservice/guide/api/georegeo#/regeo
 *
 * @author lilincheng
 * @ClassName: CooAddress
 * @Description:
 * @date 2022/1/13 下午7:57
 */
@Data
public class AddressComponentDTO {

    /**
     * 省份
     */
    private String province;

    /**
     * 城市
     */
    private String city;

    /**
     * 城市编码
     */
    private String citycode;

    /**
     * 区/县
     */
    private String district;

    /**
     * 行政区编码
     */
    private String adcode;

    /**
     * 坐标点所在乡镇/街道（此街道为社区街道，不是道路信息）
     */
    private String township;

    /**
     * 乡镇街道编码
     */
    private String towncode;

    /**
     * 社区信息列表
     */
    private NeighborhoodDTO neighborhood;

    /**
     * 楼栋信息
     */
    private BuildingDTO building;

    /**
     * 所属海域信息\例如：渤海
     */
    private String seaArea;

    /**
     * 纬度
     */
    private Double lat;

    /**
     * 经度
     */
    private Double lng;

    /**
     * 完整地址
     */
    private String formattedAddress;

    /**
     * 门牌信息列表
     * 街道名称\例如：中关村北二条
     */
    private StreetNumberDTO streetNumber;

}
