package com.bxm.newidea.component.geo.service;

import com.bxm.newidea.component.geo.dto.AddressComponentDTO;
import com.bxm.newidea.component.geo.dto.CoordinateDTO;
import com.bxm.newidea.component.geo.param.GeoPoint;

/**
 * 地理位置相关接口
 */
public interface GeoService {

    /**
     * 用途：获得单个出发点与目的地的距离
     *
     * @param origins     出发点,包含经纬度
     * @param destination 目的地,包含经纬度
     * @return 距离（单位：米）,如果参数合法，将返回-1
     */
    Double getDistance(GeoPoint origins, GeoPoint destination);

    /**
     * 根据地址获取经纬度信息 填写结构化地址信息:省份＋城市＋区县＋城镇＋乡村＋街道＋门牌号码
     *
     * @param address 详细地址
     * @return LocationInfoDTO 地址包装类
     */
    CoordinateDTO getCoordinate(String address);

    /**
     * 判断是否在（多少米）区域范围内
     *
     * @param origins     起始点
     * @param destination 目的地
     * @param radius      半径（单位米）
     * @return false：不在范围内、true：范围内
     */
    Boolean isWithinTheScopeOf(GeoPoint origins, GeoPoint destination, Long radius);

    /**
     * 判断是否在某个圆形区域内
     *
     * @param origins 起始经纬度
     * @param area1   区域经纬度1
     * @param area2   区域经纬度2
     * @return
     */
    Boolean isInArea(GeoPoint origins, GeoPoint area1, GeoPoint area2);

    /***
     * 根据经纬度信息 获取实际的地理位置
     * @param point 经纬度信息
     * @return
     */
    AddressComponentDTO getAddress(GeoPoint point);

}
